---
name: mental-health-baseline-setter
version: 1.0.0
---

# Mental Health Baseline Setter - Initialization

Establish quantified mental health baselines using validated clinical screening instruments (GAD-7, PHQ-9, RS-5). This skill helps individuals assess anxiety, depression, and resilience levels, set measurable improvement targets, and track progress over time.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with complete assessment framework

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## What This Skill Does

1. **Administers Validated Assessments**
   - GAD-7 (Generalized Anxiety Disorder - 7 items)
   - PHQ-9 (Patient Health Questionnaire - 9 items)
   - RS-5 (Resilience Scale - 5 items)

2. **Interprets Results**
   - Scores against clinical cutoffs
   - Severity classifications (minimal, mild, moderate, severe)
   - Population norm comparisons

3. **Contextual Analysis**
   - Life stressors inventory
   - Protective factors assessment
   - Social support evaluation

4. **Target Setting**
   - SMART goal framework integration
   - Goal Attainment Scaling (GAS)
   - Realistic timelines (8-12 weeks)

5. **Progress Tracking**
   - Reassessment schedules by severity
   - Progress check templates
   - Intervention recommendations

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r mental-health-baseline-setter/ ~/.claude/skills/mental-health-baseline-setter/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (everything below the second `---`)
3. Paste into your AI assistant's system prompt or custom instructions

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{assessment_duration}}` | `14_days` | Lookback period for symptom assessment |
| `{{resilience_framework}}` | `RS-5` | Resilience scale (RS-5, CD-RISC, REMAP) |
| `{{severity_threshold_action}}` | `moderate` | When to recommend professional help |
| `{{reassess_interval_days}}` | `28` | Days between reassessments |
| `{{target_reduction_percentage}}` | `30` | Minimum clinically significant change |
| `{{contextual_factors_included}}` | `true` | Whether to assess life context |

## Safety Notes

**IMPORTANT**: This is a screening tool, not diagnostic assessment.

- Always recommend professional evaluation for moderate-severe scores
- Crisis protocol included for suicidal ideation (PHQ-9 item 9)
- Crisis resources: 988 Suicide & Crisis Lifeline, Crisis Text Line

## Example Usage

**Therapy Preparation**:
"I'm starting therapy next week and want to establish where I'm at right now so I can track improvement. Give me a baseline assessment and realistic targets for the next 8 weeks."

**Self-Directed Wellness**:
"I've been feeling anxious and want to understand how bad it is. Can you help me assess my mental health and set some goals?"

**Progress Check**:
"I did a baseline assessment 4 weeks ago (GAD-7: 16, PHQ-9: 12). Can we reassess to see if I'm making progress?"

## Research Basis

Built on validated clinical instruments:
- PHQ-9: 88% sensitivity, 88% specificity for major depression
- GAD-7: 92% sensitivity, 76% specificity for anxiety disorders
- RS-5: Validated resilience measure with population norms
- ICHOM-endorsed measures for international standardization

---
Downloaded from [Find Skill.ai](https://findskill.ai)
