---
name: entertainment-recommender
version: 1.0.0
description: Personalized entertainment recommendations for movies, TV shows, books, games, and podcasts with taste profile building and explanation of WHY each pick matches your preferences
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill transforms an AI assistant into a personalized entertainment curator that goes beyond simple algorithm-based recommendations. It understands:

- The *why* behind what makes you love content
- Your current mood and context
- How to match taste dimensions across media types
- Streaming service availability
- How to handle conflicting tastes for group watching

**Time to initialize**: ~1 minute (prompt-only skill)

## Directory Structure

```
entertainment-recommender/
├── SKILL.md          # Main recommendation assistant instructions
└── INIT.md           # This initialization file
```

## Dependencies

None required. This is a prompt-only skill that works with any AI assistant.

## Files to Generate

None. This is a prompt-only skill - simply use SKILL.md directly.

## Post-Init Steps

### For Claude Code Users

```bash
# Copy to your skills directory
cp -r entertainment-recommender/ ~/.claude/skills/entertainment-recommender/
```

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy the entire content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt, custom instructions, or chat
4. Start getting personalized recommendations

## Usage Examples

### Building a Taste Profile

```
User: I loved Severance and Black Mirror but I'm kind of burned out on
dystopian stuff. Looking for something thoughtful that's well-crafted
but has more hope.

AI:
TASTE PROFILE: Thoughtful Optimist
══════════════════════════════════

Based on Severance and Black Mirror, you love:
✅ High-concept premises
✅ Sharp writing and attention to detail
✅ Stories that make you think
✅ Atmospheric, distinctive visual style
❌ Currently avoiding: Heavy dystopian content

🥇 TOP PICK: For All Mankind (Apple TV+)
Alt-history where the space race never ended. Has the high-concept
premise and meticulous world-building you love, but with a hopeful
vision of human achievement. Same prestige quality, different emotional
landing.

💡 WHY YOU'LL LOVE IT:
• Same attention to detail as Severance
• Makes you think about "what if"
• Hopeful tone about human potential
• Each season has a compelling mystery
...
```

### Quick Mood Match

```
User: Just want something fun and light, watching alone, have about 2 hours.

AI:
YOUR PERSONALIZED PICKS
════════════════════════

For fun & light, solo viewing, 2 hours:

🥇 TOP PICK: Palm Springs (2020) - 1h 30m
Smart romantic comedy with a Groundhog Day twist. Genuinely funny,
surprisingly heartfelt, and doesn't overstay its welcome.
▶️ Hulu

🥈 ALSO GREAT: Game Night (2018) - 1h 40m
Action-comedy that's way better than it has any right to be. Great
ensemble chemistry and actually clever plot twists.
▶️ HBO Max, rent on Prime

🥉 HIDDEN GEM: Barb and Star Go to Vista Del Mar (2021) - 1h 47m
Delightfully weird comedy. If you like absurdist humor, this is
incredibly rewatchable.
▶️ Hulu

Which sounds good? Want more details on any of these?
```

### Group Watch Finder

```
User: My partner loves horror but I can't handle jump scares. We want
to watch something together tonight.

AI:
TASTE OVERLAP FINDER
════════════════════

Partner: Horror fan
You: No jump scares

PERFECT COMPROMISES:

🥇 The Menu (2022)
Dark comedy thriller with horror vibes but zero jump scares. Tense,
funny, and both of you will love it for different reasons.

🥈 Get Out (2017)
If you haven't seen it - it's unsettling psychological horror, not
jump scare horror. More social thriller than traditional horror.

🥉 What We Do in the Shadows (Movie or Series)
Horror comedy - all the horror love, none of the scares. Genuinely
hilarious for everyone.

These work because they scratch the horror itch without relying on
the jump scare mechanics you want to avoid.
```

## Customization Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{media_type}}` | all | Movies, TV, books, games, podcasts, or all |
| `{{mood}}` | open to anything | Current mood or desired vibe |
| `{{time_available}}` | 2 hours | How much time for entertainment |
| `{{platform}}` | Netflix, Prime, Disney+ | Available streaming services |

## Compatibility

Tested with:
- Claude (Opus, Sonnet, Haiku)
- ChatGPT (GPT-4, GPT-4o)
- Gemini (Pro, Ultra)
- Copilot

## Tips for Best Results

1. **Share the WHY**: Instead of just listing titles you liked, share what you loved about them
2. **Mention Your Mood**: "Something fun" vs "something thoughtful" leads to very different recommendations
3. **Include Context**: Watching alone? With kids? On a date? It matters!
4. **List Your Services**: So recommendations actually show where you can watch them
5. **Feedback Loop**: If a recommendation doesn't work, explain why - it helps refine future suggestions
6. **Be Specific About Dealbreakers**: "No excessive violence" or "nothing with animals getting hurt"

## Supported Content Types

- **Movies**: All genres, international cinema, classics to current
- **TV Shows**: Series, limited series, reality, documentary, animation
- **Books**: Fiction, non-fiction, graphic novels, audiobooks
- **Video Games**: All platforms, narrative to casual
- **Podcasts**: True crime, comedy, educational, fiction, interview

## Streaming Services Covered

- Netflix, Prime Video, Disney+, Hulu
- HBO Max, Apple TV+, Peacock, Paramount+
- Criterion Channel, Shudder, AMC+
- Rental options (Prime, Apple, Vudu)
- Library apps (Kanopy, Hoopla, Libby)

---
Downloaded from [FindSkill.ai](https://findskill.ai)
