---
name: teen-text-decoder
version: 1.0.0
---

# Teen Text Decoder - Initialization

An AI skill for decoding Gen Z and teen slang, text abbreviations, and digital communication patterns. Provides context-aware translations, safety assessments, and communication guidance for parents, educators, and caregivers.

## Structure

```
teen-text-decoder/
├── SKILL.md     # Main skill prompt (500+ lines)
└── INIT.md      # This file
```

## Files to Generate

None required - this is a prompt-only skill.

## Post-Init Steps

### Claude Code Installation

```bash
# Copy skill to Claude Code skills directory
cp -r teen-text-decoder/ ~/.claude/skills/teen-text-decoder/
```

### Other AI Assistants (ChatGPT, Gemini, Copilot)

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or conversation

## Quick Start

Once installed, try these example prompts:

**Simple definition:**
```
What does "no cap fr fr" mean?
```

**Context interpretation:**
```
My daughter texted her friend: "lowkey gonna be cooked if I fail this test ngl"
Can you decode this?
```

**Safety assessment:**
```
My teen has been texting phrases like "I'm so done" and "literally can't anymore"
repeatedly. Should I be concerned?
```

**Communication guidance:**
```
My son said his new shoes are "fire" - how should I respond without being cringe?
```

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `slang_term` | (user input) | The slang word or phrase to decode |
| `context_snippet` | (optional) | Surrounding conversation for context |
| `generation_focus` | Gen Z | Target generation (Gen Z, Gen Alpha, Older Gen Z) |
| `safety_flag_sensitivity` | medium | How aggressive to flag concerns (low/medium/high) |
| `response_style` | parent-friendly | Output format (parent-friendly, educator, researcher) |

## Core Capabilities

1. **Slang Definition Lookup** - Decode specific slang terms with current definitions
2. **Context Interpretation** - Explain how meanings vary based on conversation context
3. **Tone/Intent Analysis** - Understand humor, concern, or distress indicators
4. **Cultural Awareness** - Explain slang origins including AAVE contributions
5. **Safety Assessment** - Flag language indicating potential safety concerns
6. **Communication Guidance** - Suggest parent responses that maintain trust
7. **Trend Monitoring** - Track emerging slang and what's currently popular

## Response Formats

The skill provides structured responses for different request types:

**Simple definitions** include:
- Definition, usage context, example, frequency, cultural note, concern level

**Context interpretations** include:
- Literal translation, contextual meaning, tone analysis, intent assessment, concern assessment

**Safety assessments** include:
- Language analysis, pattern recognition, risk indicators, protective factors, recommendations

## Safety Resources

The skill includes crisis resources when appropriate:
- National Suicide Prevention Lifeline: 988
- Crisis Text Line: Text HOME to 741741
- Teen Crisis Hotline: 1-800-442-HOPE

## Related Skills

- Parent-Child Communication Repair Kit
- Screen Time Negotiator
- Difficult Conversation Opener
- Assertive Communication Coach
- Family Dynamics Navigator

---
Downloaded from [Find Skill.ai](https://findskill.ai)
