---
name: tantrum-de-escalator
version: 1.0.0
---

# Tantrum De-Escalator - Initialization

Evidence-based scripts and techniques to calm toddler meltdowns using PCIT, Gottman, and emotional coaching frameworks while maintaining parental calm and child connection.

## What This Skill Does

This skill transforms your AI assistant into an expert child development specialist who provides:

- **In-the-moment scripts** for active tantrums (what to say and do right now)
- **Prevention strategies** to reduce tantrum frequency
- **Age-specific guidance** for children 18 months to 5 years
- **Parent self-regulation support** because your calm is the most powerful tool
- **Situation-specific scripts** for public tantrums, transitions, bedtime, sibling conflicts
- **Evidence-based frameworks** from PCIT, Gottman, Dr. Becky Kennedy, and Janet Lansbury

## Package Structure

```
tantrum-de-escalator/
├── SKILL.md    # Main skill prompt (copy this to use)
└── INIT.md     # This file - setup instructions
```

## Files to Generate

None required. This is a prompt-only skill.

## Installation

### Claude Code / Claude Desktop

```bash
# Copy skill to Claude Code skills directory
cp -r tantrum-de-escalator/ ~/.claude/skills/tantrum-de-escalator/
```

Then reference in your conversation:
```
Use the tantrum-de-escalator skill to help me with my toddler's meltdowns.
```

### ChatGPT / GPT-4

1. Open `SKILL.md` in a text editor
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into ChatGPT as a Custom Instruction or at the start of your conversation

### Gemini / Other AI Assistants

1. Open `SKILL.md` in a text editor
2. Copy all content after the frontmatter
3. Paste into your AI assistant as context or system prompt

## Variables

Customize the skill by mentioning these in your prompt:

| Variable | Default | Description |
|----------|---------|-------------|
| `child_age` | `3 years` | Age of the child (18 months - 5 years). Affects language complexity and reasoning expectations. |
| `tantrum_stage` | `active` | Current phase: `prevention`, `early_signs`, `active`, or `post_tantrum` |
| `location` | `home` | Where tantrum is occurring: `home`, `public`, `car`, `restaurant` |
| `child_sensory_preference` | `moderate` | Child's needs when upset: `needs_closeness`, `needs_space`, `needs_movement` |
| `trigger_type` | `boundary` | What caused it: `transition`, `boundary`, `hunger`, `tiredness`, `overstimulation`, `wants_unmet` |
| `parent_stress_level` | `calm` | Your current state: `calm`, `stressed`, `overwhelmed` |

## Example Usage

### Active Tantrum - Need Help NOW
```
My 2.5-year-old is screaming because I said no to cookies at the grocery store. 
People are staring. What do I do RIGHT NOW?
```

### Post-Tantrum Processing
```
My 4-year-old just had a massive meltdown because his sister took his toy. 
He's calm now but I want to process what happened with him. What should I say?
```

### Prevention Planning
```
My toddler has tantrums every time we leave the playground. 
What can I do to prevent this from happening?
```

### Parent Self-Regulation
```
I lost my temper during my kid's tantrum and yelled. I feel terrible.
How do I repair this and do better next time?
```

## Key Concepts

- **Co-regulation**: Children borrow your calm nervous system - your regulation enables theirs
- **Validate feelings, enforce behavior**: Feelings are always valid; actions have limits
- **Development, not defiance**: Tantrums are normal brain development, not manipulation
- **Less is more**: During peak tantrums, presence beats words
- **Consistency over perfection**: Following through matters more than perfect scripts

## Evidence Base

This skill integrates:
- Parent-Child Interaction Therapy (PCIT)
- FLIP IT Method (Feelings, Limits, Inquiry, Prompt)
- Good Inside by Dr. Becky Kennedy
- Respectful/RIE Parenting by Janet Lansbury
- Emotional Coaching by Dan Siegel and Gottman

## Disclaimer

This skill provides general parenting guidance based on established child development research. It is not a substitute for professional mental health support. Consult a pediatrician if tantrums are extreme (lasting 30+ minutes regularly, causing injury, or accompanied by concerning behaviors).

---
Downloaded from [Find Skill.ai](https://findskill.ai)
