---
name: sleep-regression-survivor
version: 1.0.0
---

# Initialization

Sleep Regression Survivor helps exhausted parents distinguish between normal developmental sleep regressions and medical concerns in infants/toddlers (0-3 years). It provides medical triage guidance, schedule auditing, and age-specific coping strategies.

## Structure

- `SKILL.md` - Main skill prompt with triage protocols, regression guides, and coping strategies

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r sleep-regression-survivor/ ~/.claude/skills/sleep-regression-survivor/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter (everything below the second `---`)
3. Paste into AI assistant as system prompt or custom instructions

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{child_age_months}}` | `6` | Age of child in months (0-36) for milestone matching |
| `{{symptom_type}}` | `night_waking` | Primary issue: night_waking, nap_refusal, early_rising, bedtime_battle, split_night |
| `{{current_method}}` | `parent_presence` | How child falls asleep: independent, parent_presence, rocking, feeding, pacifier |
| `{{regression_duration}}` | `3 days` | How long the issue has persisted |
| `{{recent_milestone}}` | `none` | New skill: rolling, crawling, standing, walking, talking, none |
| `{{feeding_type}}` | `breast` | Primary nutrition: breast, formula, mixed |

## Key Features

### Medical Triage
- Breathing concern screening (apnea, snoring)
- Fever thresholds by age
- Pain indicator assessment
- Movement disorder flags
- Clear escalation recommendations

### Regression Identification
- 4-month regression (sleep architecture change)
- 8-10 month regression (separation anxiety, motor milestones)
- 12-month regression (walking, nap transition pressure)
- 18-month regression (language explosion, molars)
- 2-year regression (imagination/fears, nightmares)

### Schedule Auditing
- Wake window guidelines by age
- Total sleep calculations
- Sleep pressure analysis
- False start troubleshooting

### Coping Strategies
- The "Pause" method
- Chair method (gradual withdrawal)
- Pick Up/Put Down method
- Wake and Sleep technique
- Skill practice interventions

## Example Prompts

**4-Month Regression:**
```
My 15-week-old was sleeping 6 hours straight, but for the last 4 nights he wakes every 45 minutes kicking his legs and fussing. We just stopped swaddling because he started rolling. Is this the 4-month regression or something else?
```

**Medical Triage:**
```
My 8-month-old is waking every hour crying. She's pulling at her ear and seems clumsy during the day. She feels warm but I haven't checked her temp. Is this teething or the 8-month regression?
```

**Toddler Bedtime:**
```
My 18-month-old used to go down easily. Now she screams "Mommy" and throws her lovey out when I leave. This has been happening for a week. She doesn't have a fever. Should I go back in or let her cry?
```

---
Downloaded from [Find Skill.ai](https://findskill.ai)
