---
name: screen-time-negotiator
version: 1.0.0
---

# Screen Time Negotiator - Initialization

Create, negotiate, and enforce iPad usage contracts with children ages 4-17 using AAP guidelines, negotiation psychology, and iOS parental controls.

## Package Structure

```
screen-time-negotiator/
├── SKILL.md     # Main skill prompt (copy to AI assistant)
└── INIT.md      # This file
```

## Files to Generate

None required - this is a prompt-only skill.

## Installation

### Claude Code / Claude Desktop
```bash
# Copy skill to Claude skills directory
cp -r screen-time-negotiator/ ~/.claude/skills/screen-time-negotiator/
```

### ChatGPT / Custom GPTs
1. Open `SKILL.md`
2. Copy all content after the `---` frontmatter block
3. Paste into Custom GPT instructions or conversation

### Gemini / Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste as system prompt or initial context

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{child_age}}` | `8` | Child's age in years (determines guidelines and language) |
| `{{daily_screen_limit_minutes}}` | `60` | Maximum daily screen time in minutes |
| `{{downtime_start_hour}}` | `19` | Hour devices lock (24-hour format, e.g., 19 = 7 PM) |
| `{{allowed_apps_list}}` | `educational,messaging,creative` | App categories or names permitted |
| `{{reward_system_enabled}}` | `true` | Include point-based reward system |
| `{{enforcement_level}}` | `balanced` | permissive, balanced, or strict |

## Quick Start

After installing, try this prompt:

> "My 7-year-old throws tantrums every time iPad time ends. She gets 3-4 hours daily, mostly YouTube and Roblox. I want a fair contract she feels ownership over. Help me create an agreement and set up the parental controls."

## Core Capabilities

1. **Contract Generation** - Age-appropriate usage agreements (templates for 4-8, 9-12, 13-17)
2. **Terms Negotiation** - Scripts for productive family discussions
3. **AAP/WHO Guidelines** - Evidence-based limits by age group
4. **iOS Setup** - Step-by-step Screen Time, Downtime, and Family Sharing configuration
5. **Conflict Resolution** - Renegotiation strategies when kids push back
6. **Reward Systems** - Point-based incentives and trust-based teen autonomy frameworks
7. **Progress Tracking** - Monthly review templates and adjustment criteria

## Key Resources

- Apple Screen Time: https://support.apple.com/en-us/HT201304
- AAP Media Guidelines: https://www.aap.org/en/patient-care-resources/media-and-children/
- Common Sense Media: https://www.commonsensemedia.org/articles/screen-time-guidelines-for-families

## Age-Based Limits (AAP/WHO)

| Age | Daily Limit | Key Notes |
|-----|-------------|-----------|
| 0-2 | None (video chat OK) | Brain development priority |
| 2-5 | Max 1 hour | Parent co-viewing required |
| 6-9 | 1-2 hours | After homework/chores only |
| 10-12 | 2 hours recreational | Begin self-monitoring |
| 13-17 | 2 hours recreational | Increasing autonomy with trust |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
