---
name: note-summarizer
version: 1.0.0
---

# Initialization

Note Summarizer transforms messy lecture notes, research papers, and study documents into clean, structured bullet points and concise takeaways. It serves students, academics, researchers, and professionals who need to convert verbose notes into digestible formats for faster review and better retention.

## Structure

- `SKILL.md` - Main skill prompt with full instructions

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r note-summarizer/ ~/.claude/skills/note-summarizer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter (starting from "You are a Note Summarizer...")
3. Paste into AI assistant as system prompt or custom instructions

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{summary_depth}}` | `balanced` | Controls detail level: quick (3-5 bullets), balanced (8-12 bullets), comprehensive (full outline) |
| `{{output_format}}` | `markdown` | Output structure: markdown, json, plain_text, or html |
| `{{include_citations}}` | `true` | Whether to include source references or page numbers |
| `{{terminology_glossary}}` | `true` | Auto-generate definitions for key terms found in notes |
| `{{refinement_iterations}}` | `1` | Number of improvement passes: 1 (quick), 2 (standard), 3+ (comprehensive) |

## Core Capabilities

1. **Single-Document Quick Summarization** - Rapidly converts notes into organized bullet points
2. **Long-Form Multi-Level Condensing** - Hierarchical summarization for large documents
3. **Research Paper to Study Guide** - Transforms papers into study materials with flashcards
4. **Raw Notes to Obsidian-Ready Format** - Converts notes to structured markdown with wiki links
5. **Incremental Refinement Workflow** - Progressive improvement through multiple passes
6. **Key Takeaway Extraction** - Identifies most important points from any source
7. **Structured Output Creation** - Generates various formats (markdown, JSON, HTML)

## Key Techniques

- **Cornell Note-Taking Method**: Cues (key terms), notes (details), summary (synthesis)
- **Feynman Technique**: Explain as if teaching someone with no background
- **Hierarchical Summarization**: Chunk → summarize → cluster → synthesize
- **Prompt Chaining**: Break complex tasks into sequential prompts
- **Active Recall**: Convert facts to flashcard Q&A format

## Example Usage

```
"I have 15 pages of messy lecture notes from my Intro to Psychology class on cognitive biases. Can you turn them into organized bullet points grouped by bias type, with key examples for each? I need this for exam prep, so highlight the most testable concepts."
```

## Output Formats

### Quick Summary
- TL;DR (30 seconds)
- Key Takeaways (5-8 bullets)
- One Thing to Remember

### Study Guide
- Overview
- Core Concepts (definition, importance, example)
- Key Terms Glossary
- Flashcards (Q&A pairs)
- Practice Questions

### Hierarchical Notes
- Level 1: Executive Summary
- Level 2: Detailed Breakdown
- Level 3: Quick Reference Table

## Best Practices

1. Use chain-of-thought prompting for step-by-step summarization
2. Break dense content into 5-10 page chunks for accuracy
3. Provide format examples for consistent output
4. Apply hierarchical summarization for documents over 5,000 tokens
5. Convert facts to questions for active recall
6. Always include "Why It Matters" context
7. Iterate with 2-3 passes for important material

## Related Skills

- Study Guide Creator - Transform summaries into study materials
- Flashcard Generator - Create memory cards from key concepts
- AI Tutor - Personalized learning assistant
- Quiz Generator - Generate practice questions
- Learning Path Designer - Build structured curricula
- Jargon Buster - Simplify complex academic language

---
Downloaded from [Find Skill.ai](https://findskill.ai)
