---
name: exam-cram-schedule
version: 1.0.0
---

# Initialization

Create strategic 3-day study plans to pass any exam using evidence-based cramming techniques, active recall, content prioritization, and cognitive preservation strategies.

## Structure

- `SKILL.md` - Main skill prompt with complete exam cramming framework

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code

```bash
cp -r exam-cram-schedule/ ~/.claude/skills/exam-cram-schedule/
```

### Other AI Assistants

1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant as system prompt or instructions
4. Begin conversation with exam details

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{exam_name}}` | `Final Exam` | The name or type of exam being prepared for |
| `{{time_until_exam}}` | `3 days` | How much time remains before the exam |
| `{{study_hours_per_day}}` | `8-10 hours` | Available study hours per day |
| `{{content_coverage_percent}}` | `40%` | Percentage of total content to study deeply |
| `{{past_papers_available}}` | `3-5` | Number of past exam papers available |
| `{{sleep_hours_minimum}}` | `7 hours` | Minimum sleep the night before exam |

## Quick Start

After installation, start with:

```
I have my [exam_name] in [time_until_exam]. I've attended classes but haven't
studied seriously. My weakest areas are [topics]. I have [number] past papers
available. What's the most effective study plan?
```

## Features

- **Content Prioritization Matrix**: Tier system for high-yield content
- **3-Day Framework**: Day-by-day schedule with hourly breakdowns
- **Active Recall Mini-Cycles**: 2.5-hour study technique for each topic
- **Past Papers Strategy**: Use old exams as primary study resource
- **Exam-Type Strategies**: Customized for multiple choice, essay, STEM
- **Scenario Handling**: Compressed schedules, no past papers, multiple exams

## Related Skills

- Flashcard Generator - Create spaced repetition cards
- Quiz Generator - Generate practice questions
- Study Guide Creator - Transform content into summaries
- Stress Management - Handle exam anxiety

---
Downloaded from [Find Skill.ai](https://findskill.ai)
