---
name: screenshot-purge-plan
version: 1.0.0
---

# Screenshot Purge Plan - Initialization

A Digital Declutter Specialist skill that helps users systematically identify, sort, and mass-delete screenshots across iOS, Android, Mac, and Windows to reclaim storage space and establish sustainable digital hygiene habits.

## Package Structure

```
screenshot-purge-plan/
├── SKILL.md      # Main skill prompt (self-contained)
└── INIT.md       # This initialization file
```

## Files to Generate

None required. This is a prompt-only skill - all instructions are contained in `SKILL.md`.

## Post-Installation Steps

### Claude Code

```bash
# Copy to Claude Code skills directory
cp -r screenshot-purge-plan/ ~/.claude/skills/screenshot-purge-plan/
```

Then reference in your project's `.claude/settings.json` or use directly.

### ChatGPT / Custom GPT

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into Custom GPT instructions or conversation

### Gemini

1. Open `SKILL.md`
2. Copy the main skill content
3. Paste as system instructions or initial prompt

### Other AI Assistants

1. Open `SKILL.md`
2. Copy content after the YAML frontmatter
3. Paste into your preferred AI assistant

## Variables Reference

| Variable | Default | Description |
|----------|---------|-------------|
| `{{device_os}}` | `iOS` | Operating system: iOS, Android, macOS, Windows |
| `{{purge_intensity}}` | `nuclear` | Deletion mode: nuclear, conservative, smart |
| `{{date_threshold}}` | `30_days` | Delete items older than this threshold |
| `{{backup_required}}` | `true` | Whether to backup before purging |
| `{{target_media_type}}` | `screenshots` | Media type: screenshots, videos, live_photos, bursts |

## Capabilities Overview

This skill enables AI assistants to:

1. **Assess** user's platform, screenshot volume, and deletion anxiety level
2. **Guide** through platform-specific mass deletion workflows
3. **Teach** OCR search techniques to find important screenshots before deletion
4. **Manage** cloud sync complications (iCloud, Google Photos, OneDrive)
5. **Prevent** future buildup with sustainable habits
6. **Handle** deletion anxiety with psychological frameworks
7. **Gamify** the process to maintain engagement

## Platform Coverage

- **iOS**: Photos app Media Types, Keep-First method
- **Android**: Google Photos, Files app, Samsung Gallery
- **macOS**: Smart Folders, Terminal commands, Hazel automation
- **Windows**: File Explorer, PowerShell, Photos app

## Quick Test

After installation, try this prompt:

> "I have 8,000 screenshots on my iPhone and I'm getting storage warnings. Help me safely mass-delete them while keeping any password or receipt screenshots."

Expected response should include:
- Assessment questions about anxiety level and cloud sync
- Recommendation for Smart purge intensity
- OCR search instructions for "password" and "receipt"
- Step-by-step iOS purge workflow
- Recently Deleted emptying reminder

## Related Skills

- `email-bankruptcy-inbox-reset` - Apply similar nuclear approach to email
- `digital-file-folder-organizer` - Organize files you keep
- `subscription-audit-automator` - Find subscription screenshots first
- `habit-tracker` - Build weekly maintenance habits
- `doomscrolling-interrupter` - Reduce screenshot-worthy scrolling

## Troubleshooting

**Skill not responding to screenshot-related prompts?**
- Ensure the full SKILL.md content was copied
- Check that frontmatter was excluded from paste
- Verify AI has access to the skill instructions

**Platform-specific steps seem outdated?**
- iOS/Android UI changes with major updates
- Core concepts remain valid; adjust navigation as needed
- Report issues at findskill.ai

---
Downloaded from [Find Skill.ai](https://findskill.ai)
