---
name: working-capital-optimizer
version: 1.0.0
---

# Initialization

Working Capital Optimizer - Analyze and optimize inventory, accounts receivable, and accounts payable cycles to maximize cash flow, reduce carrying costs, and improve financial health using Cash Conversion Cycle (CCC) analysis.

## Structure

- `SKILL.md` - Main skill prompt with comprehensive working capital optimization methodology

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r working-capital-optimizer/ ~/.claude/skills/working-capital-optimizer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{days_in_period}}` | `365` | Number of days for calculations (365 for annual, 90 for quarterly) |
| `{{dio_target_days}}` | `45` | Target Days Inventory Outstanding based on industry |
| `{{dso_target_days}}` | `35` | Target Days Sales Outstanding for collection efficiency |
| `{{dpo_target_days}}` | `40` | Target Days Payable Outstanding for cash preservation |
| `{{ccc_flexibility_tolerance}}` | `10` | Acceptable variance from CCC target (in days) before alert |
| `{{ar_automation_reduction_pct}}` | `15` | Expected DSO reduction % from AR automation investment |

## Core Capabilities

1. **Cash Conversion Cycle (CCC) Analysis** - Calculate and benchmark the time cash is tied up from inventory purchase to payment collection
2. **Inventory Optimization** - Reduce Days Inventory Outstanding (DIO) through demand forecasting and JIT strategies
3. **Accounts Receivable Acceleration** - Minimize Days Sales Outstanding (DSO) through collection optimization
4. **Accounts Payable Extension** - Strategically extend Days Payable Outstanding (DPO) to preserve cash
5. **Working Capital KPI Benchmarking** - Compare performance against industry peers and historical trends
6. **Scenario Modeling** - Simulate impact of policy changes (extended payment terms, inventory reduction)
7. **Cash Bottleneck Identification** - Pinpoint which components most significantly impact cash flow

## Key Formulas

```
CCC = DIO + DSO - DPO

DIO = (Average Inventory ÷ COGS) × Days in Period
DSO = (Average AR ÷ Revenue) × Days in Period
DPO = (Average AP ÷ COGS) × Days in Period

Early-Pay Discount Annualized Rate:
= (Discount % ÷ (100 - Discount %)) × (365 ÷ (Full Terms - Discount Period))
```

## Industry Benchmarks Reference

| Industry | DIO | DSO | DPO | Typical CCC |
|----------|-----|-----|-----|-------------|
| Manufacturing | 30-60 | 30-45 | 30-45 | 15-50 |
| Retail | 20-35 | 15-25 | 25-35 | 10-25 |
| B2B Services | 0-15 | 40-70 | 30-45 | 20-60 |
| Healthcare | 5-20 | 45-90 | 30-60 | 5-45 |
| Technology | 10-25 | 35-55 | 35-50 | 15-40 |
| E-commerce | 15-30 | 5-15 | 25-40 | 0-20 |

## Target Audience

- CFOs and Finance Directors
- Finance & Accounting Teams
- Business Owners/Entrepreneurs
- Supply Chain Managers
- Financial Analysts and Consultants

---
Downloaded from [Find Skill.ai](https://findskill.ai)
