---
name: unit-economics-analyzer
version: 1.0.0
---

# Unit Economics Analyzer - Initialization

Calculate and analyze SaaS unit economics including CAC, LTV, LTV:CAC ratio, payback period, churn rates, and net revenue retention to measure business health and profitability.

## Package Structure

```
unit-economics-analyzer/
├── SKILL.md     # Main skill prompt with all formulas and templates
└── INIT.md      # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill.

## Post-Installation Steps

### For Claude Code Users

```bash
# Copy skill to Claude Code skills directory
cp -r unit-economics-analyzer/ ~/.claude/skills/unit-economics-analyzer/
```

### For Other AI Assistants (ChatGPT, Gemini, Copilot)

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's custom instructions or system prompt
4. Start analyzing your unit economics

## Quick Start

After installation, provide your business metrics:

```
Analyze my unit economics:
- ARPU: $150/month
- Gross Margin: 70%
- Monthly Churn: 4%
- Monthly Marketing Spend: $20,000
- New Customers/Month: 80
```

The AI will calculate:
- CAC (Customer Acquisition Cost)
- LTV (Customer Lifetime Value)
- LTV:CAC Ratio
- CAC Payback Period
- Retention metrics
- Benchmarking against industry standards

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `average_revenue_per_user_monthly` | $100 | Monthly ARPU based on your pricing tiers |
| `gross_margin_percentage` | 75% | Revenue after COGS (SaaS typically 70-90%) |
| `monthly_churn_rate` | 3% | Customer loss rate per month |
| `total_acquisition_spend` | $10,000 | All marketing and sales costs monthly |
| `new_customers_monthly` | 50 | New customers acquired per month |
| `expansion_revenue_rate` | 2% | Monthly MRR growth from existing customers |

## Key Features

### Core Calculations
- **CAC**: Total acquisition costs ÷ new customers
- **LTV**: (ARPU × Gross Margin) ÷ Churn Rate
- **LTV:CAC Ratio**: Target 3:1 or higher
- **Payback Period**: CAC ÷ Monthly Gross Profit

### Advanced Analysis
- Channel-level CAC breakdown
- Cohort-based LTV analysis
- Net Revenue Retention (NRR)
- Scenario modeling for pricing changes
- Investor-ready presentation format

### Industry Benchmarks

| Metric | SaaS Target | Enterprise Target |
|--------|-------------|-------------------|
| LTV:CAC | 3-5:1 | 4-8:1 |
| Payback | 12-18 months | 18-24 months |
| Gross Margin | 70-90% | 80-95% |
| Monthly Churn | <2-5% | <2% |

## Example Outputs

### Quick Analysis
```
UNIT ECONOMICS ANALYSIS
=======================

📊 CORE METRICS
CAC: $250 (Healthy for B2B SaaS)
LTV: $3,750 (25-month customer lifetime)
LTV:CAC: 15:1 (Excellent)
Payback: 2.2 months (Outstanding)

🎯 VERDICT: HEALTHY

💡 RECOMMENDATIONS:
1. Consider scaling acquisition spend
2. Test higher price points
3. Build expansion revenue programs
```

### Channel Breakdown
```
| Channel | CAC | LTV:CAC | Recommendation |
|---------|-----|---------|----------------|
| Paid    | $400| 9.4:1   | Scale carefully|
| Organic | $80 | 46.9:1  | Invest heavily |
| Social  | $285| 13.2:1  | Maintain       |
```

## Troubleshooting

### LTV:CAC Below 2:1
- Reduce CAC by shifting to efficient channels
- Improve retention to extend customer lifetime
- Review pricing for potential increases

### Payback Over 18 Months
- Increase gross margin where possible
- Focus on high-value customer segments
- Consider annual prepay discounts

## Related Skills

- SaaS Churn Analyzer
- Cohort Analysis
- Financial Projections Generator
- Pricing Strategy Analyzer
- Customer Analytics
- KPI & Metrics Designer

---

Downloaded from [Find Skill.ai](https://findskill.ai)
