---
name: startup-traction-scorecard
version: 1.0.0
---

# Initialization

Calculate and score your startup's traction across 7 dimensions: viral coefficient, retention health, financial sustainability, growth engine type, and composite traction score with stage-specific benchmarks.

## Structure

- `SKILL.md` - Main skill prompt with scoring frameworks, formulas, and benchmarks

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r startup-traction-scorecard/ ~/.claude/skills/startup-traction-scorecard/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter (starting from "You are a Startup Traction Analyst...")
3. Paste into AI assistant as system prompt or conversation starter

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{business_model}}` | `B2B SaaS` | Business model type for benchmark calibration (B2B SaaS, B2C SaaS, Marketplace, Consumer App, E-commerce) |
| `{{growth_stage}}` | `Seed` | Current stage for context-appropriate thresholds (Pre-seed, Seed, Series A, Series B+) |
| `{{scoring_focus}}` | `Balanced` | Which dimension to weight most heavily in composite score |
| `{{data_completeness}}` | `Partial` | How much metrics data you have available |
| `{{time_period}}` | `3` | Analysis time window in months |
| `{{currency}}` | `USD` | Currency for financial calculations |

## Quick Start

Provide your startup metrics and get a comprehensive traction scorecard:

**Example prompt:**
> I'm running a B2B SaaS at Seed stage with 3 months of data. Here are my metrics: 500 MAU, 150 DAU, 8% monthly churn, $45 CAC, $180 ARPU, 18-month average customer lifespan. Each user sends 2 invitations per month with 15% conversion rate. Calculate my viral coefficient, LTV:CAC ratio, DAU/MAU stickiness, and give me a composite traction score with recommendations.

## Scoring Dimensions

The skill evaluates 7 dimensions:

1. **Viral Coefficient** - k-factor and viral loop timing
2. **DAU/MAU Stickiness** - Engagement frequency relative to business model
3. **Retention Health** - Churn rate, D30 retention, curve shape
4. **Financial Sustainability** - LTV:CAC ratio, CAC payback period
5. **Net Revenue Retention** - Expansion vs. contraction for SaaS
6. **Segmented Traction** - Bright spots and problem areas by segment
7. **Growth Engine Fit** - Viral, sticky, or paid engine classification

## Key Formulas

```
Viral Coefficient (k) = Invitations × Conversion Rate
Stickiness = DAU / MAU × 100
LTV = ARPU × Customer Lifespan (months)
LTV:CAC = LTV / CAC
NRR = (Starting MRR + Expansion - Contraction - Churn) / Starting MRR × 100
```

## Benchmarks Quick Reference

**LTV:CAC Ratio:**
- < 1.5:1 = Unsustainable
- 2-3:1 = Approaching healthy
- 3-5:1 = Healthy, scalable
- > 5:1 = Possibly underinvesting

**NRR (SaaS):**
- < 90% = Concerning
- 100-110% = Good
- 110-120% = Strong
- > 120% = Excellent

**DAU/MAU by Model:**
- Social/Communication: >50% excellent
- B2B SaaS: >25% good
- Consumer Sub: >20% good
- Marketplace: >15% good

---
Downloaded from [Find Skill.ai](https://findskill.ai)
