---
name: related-party-transaction-analyzer
version: 1.0.0
---

# Related Party Transaction Analyzer - Initialization

An AI skill for identifying, classifying, and analyzing related party transactions (RPTs) in compliance with international accounting standards (IAS 24, ASC 850) and auditing standards (ISA 550, PCAOB AS 2410). Detects fraud patterns, assesses arm's length terms, and prepares accurate financial statement disclosures.

## Package Structure

```
related-party-transaction-analyzer/
├── SKILL.md    # Main skill prompt with complete RPT analysis framework
└── INIT.md     # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill. The SKILL.md contains the complete instruction set.

## Post-Installation Steps

### For Claude Code Users

```bash
# Copy skill to Claude Code skills directory
cp -r related-party-transaction-analyzer/ ~/.claude/skills/related-party-transaction-analyzer/
```

Then invoke with:
```
use skill related-party-transaction-analyzer
```

### For ChatGPT, Gemini, Copilot Users

1. Open `SKILL.md`
2. Copy all content after the frontmatter (below the second `---`)
3. Paste into your AI assistant as a custom instruction or system prompt
4. Begin with your related party transaction analysis query

## Core Capabilities

| Capability | Description |
|------------|-------------|
| Related Party Identification | Map all related parties from org structures, board interlocks, ownership hierarchies |
| Transaction Classification | Categorize by relationship type, transaction nature, and risk profile (tone at top vs. business necessity) |
| Risk Assessment & Red Flags | Detect suspicious indicators: unusual timing, pricing mismatches, weak documentation |
| Audit Procedure Design | Generate tailored substantive and analytical procedures based on transaction risk |
| Arm's Length Assessment | Evaluate transaction terms against market standards using transfer pricing methods |
| Disclosure Compliance | Verify completeness against IAS 24/ASC 850/ISA 550 requirements |
| Earnings Management Detection | Flag manipulation patterns: margin anomalies, timing patterns, volume spikes |

## Variables Reference

| Variable | Default | Description |
|----------|---------|-------------|
| `{{reporting_standard}}` | `IFRS` | Accounting framework: IFRS, GAAP, ASPE, IPSAS |
| `{{materiality_threshold}}` | `5%` | Percentage threshold for material RPT disclosure/testing |
| `{{related_party_category}}` | `all` | Filter: parent_subsidiary, associates, joint_ventures, key_management, government_related |
| `{{transaction_type_filter}}` | `all` | Filter: sales, purchases, loans, guarantees, leases, management_fees |
| `{{tone_at_top_risk_level}}` | `medium` | Baseline risk: low, medium, high |
| `{{arm_length_evidence_threshold}}` | `contemporaneous` | Documentation requirement: contemporaneous, post-hoc, none |

## Example Usage

**Related Party Identification:**
```
I'm auditing a pharmaceutical company with 15 subsidiaries across 8 countries and
3 joint ventures in Europe. Help me create a systematic identification procedure
to capture all related party relationships including direct ownership, board
interlocks, and management secondments. Prior year documented 47 relationships.
```

**Risk Assessment:**
```
Our founder owns 35% through a private equity entity with these transactions:
- $5M annual software licensing agreement
- Office space lease with founder guarantee
- Preferred equity investment
- IP rights transfer last year

Given prior year earnings management concerns, classify each transaction's risk
profile and design substantive procedures with appropriate skepticism.
```

**Disclosure Review:**
```
We have 23 distinct RPT types this year (ranging from $50K purchases to $8M
IP licensing). Review our IAS 24 disclosure draft for completeness, proper
classification, arm's length assertions, and required format elements.
```

## Standards Covered

| Standard | Purpose |
|----------|---------|
| IAS 24 | IFRS disclosure requirements for related party transactions |
| ASC 850 | US GAAP related party disclosure requirements |
| ISA 550 | International auditing standard for related parties |
| PCAOB AS 2410 | US public company audit requirements for related parties |
| SEC Reg S-K Item 404 | US registrant related person transaction disclosure |

## Ideal For

- **Internal Auditors** - Designing audit programs for related party reviews
- **External Auditors** - Performing RPT risk assessments and substantive testing
- **Financial Accountants** - Preparing financial statement disclosures
- **Controllers/CFOs** - Overseeing RPT governance and disclosure accuracy
- **Compliance Teams** - SEC/stock exchange filing requirements
- **Fraud Examiners** - Investigating suspicious related party activity

## Key Deliverables

The skill generates these outputs:

1. **Related Party Identification Schedule** - Stratified database of all relationships
2. **Risk Assessment Matrix** - Scored categorization (Low/Medium/High) for audit allocation
3. **Audit Procedure Programs** - Step-by-step testing procedures by risk level
4. **Arm's Length Assessment Memo** - Transfer pricing method application and conclusions
5. **Disclosure Compliance Checklist** - IAS 24/ASC 850 requirements verification
6. **Earnings Management Risk Report** - Margin, timing, and volume anomaly analysis
7. **Management Letter Points** - Findings for governance communication

## Troubleshooting

| Issue | Solution |
|-------|----------|
| Incomplete related party list | Use bottom-up approach: analyze unusual transactions to find hidden relationships |
| Missing arm's length support | Request post-hoc transfer pricing analysis or engage specialist |
| Period-end transaction concentration | Expand sample, test post-period reversals, apply ISA 240 fraud procedures |
| Weak authorization evidence | Assess as control deficiency, consider management override indicators |
| Generic disclosure language | Provide detailed checklist and peer company examples |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
