---
name: post-product-launch-prioritizer
version: 1.0.0
---

# Initialization

Post-Product Launch Prioritizer helps product teams identify the 2-3 highest-impact metrics and initiatives after product launch. It cuts through data noise using impact-effort prioritization frameworks to surface high-value, resource-efficient opportunities for improving retention, activation, and revenue.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive prioritization frameworks

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r post-product-launch-prioritizer/ ~/.claude/skills/post-product-launch-prioritizer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (everything below the second `---`)
3. Paste into your AI assistant's system prompt or custom instructions

## Compatibility

Tested with: Claude, ChatGPT, Gemini, Copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{target_metric}}` | `retention` | Primary North Star metric (retention, activation, revenue, engagement) |
| `{{analysis_period_days}}` | `30` | Days post-launch to analyze |
| `{{segment_focus}}` | `all_users` | User segment to prioritize (power_users, at_risk, enterprise, smb) |
| `{{max_initiatives}}` | `3` | Maximum initiatives to prioritize |
| `{{business_context}}` | `saas` | Business model (saas, mobile_app, marketplace, enterprise) |

## Quick Start

After installation, start a conversation with:

```
I launched a [SaaS/mobile app/marketplace] [X days/weeks] ago. Current metrics:
- Sign-ups: [number]
- Activation rate: [X%]
- Week-1 retention: [X%]
- Conversion rate: [X%]

My biggest concern is [retention/activation/revenue/engagement].

Here are initiatives we're considering:
1. [Initiative A] - [effort estimate]
2. [Initiative B] - [effort estimate]
3. [Initiative C] - [effort estimate]

Help me prioritize the top 2-3 to focus on.
```

## Example Usage

### SaaS Post-Launch Prioritization
```
We launched our project management SaaS 2 weeks ago. 1,200 trial sign-ups, 30% activation rate, 25% Week-1 retention (dropping). Support tickets are 60% onboarding-related.

Candidates:
1. Simplify onboarding flow (medium effort, +15% activation estimate)
2. Add setup wizard (low effort, +8% activation estimate)
3. Improve documentation (low effort, +3% activation estimate)

Which 2-3 should we prioritize?
```

### Mobile App Churn Analysis
```
Our fitness app has severe churn: 88% gone by Week 2. Session replays show users open 1-2 times then abandon. They complete onboarding but don't start workouts.

Hypotheses:
1. Unclear how to start first workout (UX friction)
2. Workout library too generic (value prop issue)
3. Notifications too aggressive

How should we prioritize investigation and fixes?
```

### Marketplace Revenue Optimization
```
Our two-sided marketplace: 500 sellers, 2,000 buyers, only 8% buyer-seller transaction rate. Revenue $2K/month, need $50K by Month 2.

Candidates:
1. Improve search/discoverability (medium effort)
2. Simplify checkout (low effort, -20% abandonment estimate)
3. Seller incentive program (low effort + cost)

Enterprise buyers (100 users) have 18% transaction rate. Should we focus on enterprise or mass market? Which initiative first?
```

## Key Frameworks Included

- **Impact-Effort Matrix**: Score initiatives and calculate Priority = (Impact × Segment Value) ÷ Effort
- **AARRR Pirate Metrics**: Full-funnel analysis (Acquisition, Activation, Retention, Revenue, Referral)
- **Root Cause Framework**: Symptom → Investigation → Finding → Hypothesis → Validation → Solution
- **Segment Value Weighting**: Enterprise (2-3x), Power users (1.5-2x), At-risk (1.5x), Free (0.5-1x)
- **Quick Win Identification**: Filter for Effort ≤ 4 and Impact ≥ 6

## Benchmarks Reference

| Metric | Target | Concern |
|--------|--------|---------|
| Activation Rate | 30%+ | <25% |
| Week-1 Retention | 30%+ | <20% |
| Month-1 Retention | 20%+ | <15% |
| NPS | 30+ (MVP) | <20 |
| Trial-to-Paid (SaaS SMB) | 15-25% | <10% |
| LTV:CAC Ratio | 3:1+ | <2:1 |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
