---
name: intercompany-transaction-tracker
version: 1.0.0
---

# Initialization

Intercompany Transaction Tracker - Document, reconcile, and eliminate intercompany transactions for financial consolidation. This skill helps CFOs, consolidation accountants, and finance controllers manage multi-entity transactions, generate elimination entries, ensure transfer pricing compliance, and accelerate financial close processes.

## Structure

- `SKILL.md` - Main skill prompt with comprehensive intercompany accounting guidance

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r intercompany-transaction-tracker/ ~/.claude/skills/intercompany-transaction-tracker/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{reconciliation_frequency}}` | `monthly` | How often reconciliation cycles execute (daily, weekly, monthly, quarterly) |
| `{{tolerance_threshold}}` | `1000` | Dollar amount below which transactions auto-reconcile; above triggers exception review |
| `{{transfer_pricing_method}}` | `comparable_uncontrolled_price` | Transfer pricing methodology (CUP, resale_price, cost_plus, profit_split, TNMM) |
| `{{minority_interest_treatment}}` | `proportional_elimination` | How to allocate elimination adjustments to NCI (proportional, consolidated_only) |
| `{{data_currency_standard}}` | `functional_currency` | Currency for standardization (functional_currency, parent_currency, USD) |
| `{{audit_trail_retention_days}}` | `2555` | Minimum days to retain audit trail (default: 7 years per US standards) |

## Key Capabilities

1. **Multi-ERP Data Integration** - Extract, transform, and standardize intercompany transaction data from SAP, Oracle, NetSuite, and other systems
2. **Automated Transaction Matching** - Match invoices between sender and receiver using amount, date, currency, and invoice number logic
3. **Intercompany Elimination** - Generate elimination entries for sales, purchases, receivables, payables, and unrealized profits
4. **Transfer Pricing Documentation** - Maintain arm's-length pricing support per OECD/IRS requirements
5. **Real-Time Reconciliation** - Dashboard visibility into outstanding balances, aging, and unmatched items
6. **Consolidation Workflow** - Route transactions for review with segregation of duties and audit trail
7. **Compliance Reporting** - Consolidated statements, elimination schedules, audit-ready documentation

## Regulatory Standards Covered

- **IFRS 10/IAS 27** - Consolidated financial statements
- **ASC 810** - US GAAP consolidation
- **OECD Transfer Pricing Guidelines** - Arm's length pricing
- **IRS Section 482** - Transfer pricing documentation
- **SOX 404** - Internal controls

## Target Users

- CFOs and Finance Directors
- Consolidation Accountants
- Transfer Pricing Specialists
- Financial Controllers
- Internal/External Auditors
- Tax Professionals

---

Downloaded from [Find Skill.ai](https://findskill.ai)
