---
name: financial-ratio-analyzer
version: 1.0.0
---

# Initialization

The Financial Ratio Analyzer skill helps you calculate and interpret liquidity, profitability, and efficiency ratios from financial statement inputs. It provides plain-language insights about company financial health, peer comparisons, and red flag detection.

## Structure

```
financial-ratio-analyzer/
├── SKILL.md    # Main skill prompt (copy to AI assistant)
└── INIT.md     # This file
```

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
# Copy skill to Claude Code skills directory
cp -r financial-ratio-analyzer/ ~/.claude/skills/financial-ratio-analyzer/
```

### ChatGPT, Gemini, Copilot, or Other AI Assistants
1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or custom instructions
4. Start analyzing financial ratios

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{analysis_scope}}` | `liquidity_profitability_efficiency` | Which ratio families to include (liquidity_only, profitability_only, all_including_leverage) |
| `{{industry_context}}` | `generic` | Industry tag for benchmark comparison (software, manufacturing, retail, etc.) |
| `{{trend_years}}` | `3` | Number of historical years for trend analysis |
| `{{detail_level}}` | `standard` | Verbosity of explanations (brief, standard, deep_dive) |
| `{{benchmark_mode}}` | `none` | Comparison mode (none, user_provided, industry_default) |
| `{{risk_flag_sensitivity}}` | `medium` | How aggressively to flag concerns (low, medium, high) |

## Usage Examples

### Basic Single-Year Analysis
```
Analyze my company's financial ratios for 2024:
- Revenue: $2,400,000
- COGS: $1,560,000
- Operating expenses: $540,000
- Net income: $200,000
- Total assets: $1,200,000
- Total equity: $700,000
- Current assets: $480,000 (inventory $220,000, cash $90,000)
- Current liabilities: $260,000
- Average accounts receivable: $180,000
- Average inventory: $210,000

Industry: retail
```

### Multi-Year Trend Analysis
```
Run a 5-year financial ratio analysis for my manufacturing company
using the following data:

[Provide summarized financial statements for each year]

Focus on liquidity, profitability, and efficiency trends.
Use deep_dive detail level and high risk flag sensitivity.
```

### Pre-Calculated Ratio Review
```
I have these ratios from a stock screener for a manufacturing company:
- Current ratio: 1.4
- Quick ratio: 0.9
- Gross margin: 32%
- Operating margin: 14%
- Net margin: 9%
- ROA: 7%
- ROE: 18%
- Asset turnover: 0.8
- Inventory turnover: 5x
- DSO: 48 days

Interpret these like an experienced investor. What are the strengths,
weaknesses, and follow-up questions I should investigate?
```

## Core Capabilities

1. **Liquidity Analysis** - Current ratio, quick ratio, cash ratio
2. **Profitability Analysis** - Margins, ROA, ROE, DuPont decomposition
3. **Efficiency Analysis** - Asset turnover, DSO, DIO, cash conversion cycle
4. **Trend Analysis** - Multi-period comparison and direction assessment
5. **Industry Benchmarking** - Context-aware interpretation
6. **Red Flag Detection** - Early warning identification
7. **Integrated Reporting** - Comprehensive narrative assessments

## Key Formulas Reference

```
LIQUIDITY
---------
Current Ratio = Current Assets / Current Liabilities
Quick Ratio = (Current Assets - Inventory) / Current Liabilities
Cash Ratio = (Cash + Equivalents) / Current Liabilities

PROFITABILITY
-------------
Gross Margin = (Revenue - COGS) / Revenue
Operating Margin = Operating Income / Revenue
Net Margin = Net Income / Revenue
ROA = Net Income / Total Assets
ROE = Net Income / Shareholders' Equity

EFFICIENCY
----------
Asset Turnover = Revenue / Total Assets
Receivables Turnover = Revenue / Avg Accounts Receivable
DSO = 365 / Receivables Turnover
Inventory Turnover = COGS / Avg Inventory
DIO = 365 / Inventory Turnover
CCC = DIO + DSO - DPO
```

## Industry Benchmark Quick Reference

| Industry | Current Ratio | Gross Margin | Net Margin | Asset Turnover |
|----------|--------------|--------------|------------|----------------|
| Software/SaaS | 2.0-4.0 | 70-90% | 10-25% | 0.5-1.0 |
| Retail | 1.2-2.0 | 25-40% | 2-7% | 2.0-4.0 |
| Manufacturing | 1.2-2.0 | 20-35% | 3-10% | 0.8-1.5 |
| Professional Services | 1.5-3.0 | 50-80% | 8-20% | 1.0-2.5 |

## Related Skills

- **Financial Analytics** - General financial modeling and reporting
- **Investment Analyzer** - Stock and ETF fundamental analysis
- **Cash Flow Projector** - Future cash flow planning
- **Budget Variance Analyzer** - Actual vs. budget comparison
- **Financial Projections Generator** - Multi-year forecasting

---
Downloaded from [Find Skill.ai](https://findskill.ai)
