---
name: competitor-review-spy
version: 1.0.0
---

# Competitor Review Spy - Initialization

Transform competitor negative reviews into actionable product intelligence. This skill systematically analyzes customer complaints to uncover market gaps, underserved segments, and differentiation opportunities.

## Structure

```
competitor-review-spy/
├── SKILL.md    # Main skill prompt (copy to AI assistant)
└── INIT.md     # This initialization file
```

## Files to Generate

None required (prompt-only skill)

## Post-Init Steps

### Claude Code Installation

```bash
# Copy skill to Claude Code skills directory
cp -r competitor-review-spy/ ~/.claude/skills/competitor-review-spy/
```

### ChatGPT / Gemini / Copilot

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or initial message
4. Start with a quick start command

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{competitor_name}}` | `""` | Primary competitor to analyze |
| `{{review_star_filter}}` | `"1-2"` | Star rating filter (1-2 for max pain) |
| `{{review_volume}}` | `"50"` | Number of reviews to analyze |
| `{{customer_segment_focus}}` | `"all"` | Target segment (SMB, enterprise, all) |
| `{{analysis_timeframe}}` | `"6"` | Months of historical reviews |
| `{{pain_point_threshold}}` | `"5%"` | Minimum frequency to count as pattern |

## Quick Start Commands

After loading the skill, try these:

**Guided Collection:**
```
Help me collect and analyze negative reviews for Notion from G2
```

**Direct Analysis:**
```
Here are 50 negative reviews of [Competitor]. Extract pain points and differentiation opportunities.
```

**Full Competitive Map:**
```
I'm competing with Notion, Coda, and Airtable. Help me map positioning gaps and find underserved segments.
```

## Use Cases

1. **Product Managers** - Prioritize roadmap based on competitor weaknesses
2. **Founders** - Find market gaps before building
3. **Product Marketers** - Craft positioning against competitor pain points
4. **Sales Teams** - Build battlecards with competitor weaknesses
5. **UX Designers** - Understand common frustrations with alternatives

## Review Collection Platforms

| Platform | Best For | URL |
|----------|----------|-----|
| G2 | B2B SaaS | g2.com |
| Capterra | Business Software | capterra.com |
| Trustpilot | B2B & Consumer | trustpilot.com |
| App Store | iOS Apps | apps.apple.com |
| Google Play | Android Apps | play.google.com |
| Amazon | Consumer Products | amazon.com |
| Reddit | All Categories | reddit.com |

## Output Formats

The skill generates:
- **Pain Point Analysis** - Categorized complaints with frequency
- **Segment Analysis** - Which customer types are most frustrated
- **Positioning Maps** - Visual competitive landscape
- **Feature Gap Roadmaps** - Prioritized product opportunities
- **Messaging Opportunities** - Differentiation angles

---
Downloaded from [Find Skill.ai](https://findskill.ai)
