---
name: break-even-analysis-generator
version: 1.0.0
---

# Break-Even Analysis Generator - Initialization

Calculate break-even points in units and revenue, analyze multi-product scenarios with weighted contribution margins, and run sensitivity analysis for pricing and cost decisions.

## What This Skill Does

This skill transforms your AI assistant into an expert financial analyst for break-even calculations. It handles:

- **Single-Product Analysis** - Calculate units and revenue needed to break even
- **Multi-Product Scenarios** - Weighted contribution margins across product portfolios
- **Sensitivity Analysis** - Model pricing, cost, and volume scenarios
- **Margin of Safety** - Assess financial buffer and risk level
- **Target Profit Planning** - Determine sales needed for specific profit goals

## Package Structure

```
break-even-analysis-generator/
├── SKILL.md    # Main skill prompt (copy to your AI)
└── INIT.md     # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill.

## Installation

### Claude Code (Recommended)

```bash
# Copy skill to Claude Code skills directory
cp -r break-even-analysis-generator/ ~/.claude/skills/break-even-analysis-generator/
```

Then reference in your project's `.claude/settings.json`:
```json
{
  "skills": ["break-even-analysis-generator"]
}
```

### ChatGPT / Claude Web / Gemini

1. Open `SKILL.md` in a text editor
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's custom instructions or system prompt
4. Start a new conversation

### API Integration

Include the SKILL.md content as a system message in your API calls.

## Quick Start

After installing, try these prompts:

**Basic Break-Even:**
```
I'm launching a consulting service with $5,000/month fixed costs,
$500 variable cost per project, and I'll charge $2,500 per project.
What's my break-even point?
```

**Multi-Product Analysis:**
```
My SaaS has $50,000/month fixed costs. I sell three plans:
- Starter: $29/month (40% of customers)
- Pro: $99/month (35% of customers)
- Enterprise: $499/month (25% of customers)
Variable costs are $3/month per user. What's my break-even?
```

**Sensitivity Analysis:**
```
I run a coffee shop with $8,000/month fixed costs.
Currently: 85 customers/day, $5 average price, $2.50 variable cost.
What happens to break-even if I raise prices to $6 or $7?
```

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{fixed_costs_monthly}}` | 10000 | Total monthly fixed costs |
| `{{variable_cost_per_unit}}` | 15 | Variable cost per unit |
| `{{selling_price_per_unit}}` | 50 | Selling price per unit |
| `{{desired_profit_target}}` | 0 | Target profit (0 = break-even only) |
| `{{analysis_type}}` | single-product | Analysis type needed |

## Key Formulas

**Break-Even (Units):**
```
BEP = Fixed Costs / (Selling Price - Variable Cost)
```

**Break-Even (Revenue):**
```
BEP Revenue = Fixed Costs / Contribution Margin Ratio
```

**Contribution Margin:**
```
CM = Selling Price - Variable Cost per Unit
CM Ratio = CM / Selling Price
```

**Margin of Safety:**
```
MOS = (Current Sales - BEP) / Current Sales × 100
```

**Target Profit Volume:**
```
Units = (Fixed Costs + Desired Profit) / CM per Unit
```

## Industry Benchmarks

**Contribution Margin Ratios:**
- Manufacturing: 30-50%
- Retail: 25-45%
- Services: 50-70%
- SaaS: 70-90%

**Healthy Margin of Safety:**
- Minimum: 10-15%
- Good: 20-30%
- Excellent: 30%+

## Troubleshooting

**"My break-even seems too high"**
- Verify all fixed costs are captured
- Check if variable costs include all direct expenses
- Consider if price is competitive

**"I can't categorize certain costs"**
- Semi-variable costs should be split
- Use the high-low method with historical data
- When unsure, ask the AI to help classify

**"Multi-product calculations are confusing"**
- Ensure sales mix percentages total 100%
- The AI will calculate weighted average CM
- Results show breakdown by product

## Related Skills

- [Cost Structure Analyzer](/skills/data-analytics/cost-structure-analyzer/) - Fixed vs. variable cost breakdown
- [Cost-Benefit Analysis](/skills/data-analytics/cost-benefit-analysis/) - NPV, ROI, IRR calculations
- [Pricing Strategy Analyzer](/skills/productivity/pricing-strategy-analyzer/) - Optimal pricing strategies
- [Cash Flow Projection Generator](/skills/data-analytics/cash-flow-projection-generator/) - Monthly cash flow forecasting

---
Downloaded from [Find Skill.ai](https://findskill.ai)
