---
name: ai-spy-competitive-intelligence
version: 1.0.0
description: Competitive intelligence system for monitoring competitors and market shifts
author: FindSkill.ai
license: MIT
---

# Initialization

This skill transforms AI into a competitive intelligence analyst that helps you monitor competitors, detect market shifts, and uncover strategic opportunities.

## Overview

**What this skill does:**
- Conducts systematic competitor analysis using the RADAR framework
- Creates competitive intelligence briefings
- Sets up monitoring frameworks for ongoing intelligence
- Provides early warning signals for competitive threats

**Time to initialize:** ~1 minute (prompt-only skill)

## Directory Structure

```
ai-spy-competitive-intelligence/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization file
```

## Dependencies

None - this is a prompt-only skill.

## Files to Generate

None - copy SKILL.md content directly to use.

## Post-Init Steps

### For Claude Code Users
```bash
# Copy to your skills directory
cp -r ai-spy-competitive-intelligence/ ~/.claude/skills/
```

### For Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or start a new conversation with it

## Compatibility

Tested with:
- Claude (Opus, Sonnet, Haiku)
- ChatGPT (GPT-4, GPT-4o)
- Gemini (Pro, Ultra)
- Copilot

## Variables

Customize these in your prompts:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{industry}}` | SaaS / B2B Software | Your industry segment |
| `{{competitors}}` | Competitor A, B, C | Your key competitors |
| `{{intelligence_focus}}` | pricing, features, marketing | What to monitor |

## Quick Start

After initialization, try these prompts:

1. **Full competitive analysis:**
   "I run a [product type] company. My competitors are [list]. Create a competitive intelligence briefing."

2. **Specific competitor deep-dive:**
   "Do a deep competitive analysis of [competitor name] - their pricing, features, positioning, and recent moves."

3. **Set up monitoring:**
   "Help me set up a weekly competitive monitoring framework for [industry]."

4. **Threat assessment:**
   "My competitor just [action]. Assess the threat level and recommend a response."

## Key Frameworks

### RADAR Framework
- **R**econnaissance - Gather baseline intelligence
- **A**nalysis - Deep-dive into competitive dynamics
- **D**etection - Monitor for changes and signals
- **A**ssessment - Evaluate strategic implications
- **R**eporting - Deliver actionable intelligence

### Signal Intelligence
Monitor these early warning indicators:
- Hiring surges (expansion signals)
- Executive hires (strategic pivots)
- Pricing page changes (repositioning)
- Job posting patterns (product direction)
- Partnership announcements (ecosystem moves)

---
Downloaded from [Find Skill.ai](https://findskill.ai)
