---
name: video-script-pacing-check
version: 1.0.0
---

# Initialization

Video Script Pacing Check is an AI skill for content creators to analyze video script pacing, predict viewer drop-off points, and optimize audience retention using industry benchmarks.

## Structure

- `SKILL.md` - Main skill prompt with comprehensive retention analysis framework

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r video-script-pacing-check/ ~/.claude/skills/video-script-pacing-check/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant
4. Provide your video script for analysis

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{intro_length_seconds}}` | `5` | Target intro length before main content (optimal: 3-5 seconds) |
| `{{target_audience_persona}}` | `general` | Viewer type: casual_entertainment, dedicated_learner, professional, general |
| `{{value_prop_placement_seconds}}` | `15` | Target timestamp for core message delivery |
| `{{pattern_interrupt_frequency_seconds}}` | `25` | Frequency of visual/narrative changes (15-30 seconds recommended) |
| `{{video_length_minutes}}` | `7` | Total video duration for drop-off prediction |
| `{{content_type}}` | `general` | Video category: tutorial, storytelling, educational, entertainment, review, product_demo |

## Key Capabilities

1. **Hook Strength Analysis** - Evaluates opening effectiveness on 1-10 scale
2. **Intro Length Assessment** - Compares against 3-5 second optimal benchmark
3. **Value Proposition Mapping** - Checks if core message appears within 15 seconds
4. **Drop-off Prediction** - Forecasts where viewers will abandon based on script structure
5. **Pattern Interrupt Detection** - Identifies engagement breaks and gaps
6. **Audience Persona Alignment** - Adjusts recommendations for viewer type
7. **Re-hook Formula Validation** - Confirms mid-video engagement elements

## Industry Benchmarks Referenced

- 55% of viewers abandon within first 60 seconds
- 1 in 5 viewers leave within first 10 seconds
- Optimal intro length: 3-5 seconds
- Value proposition must appear within 15 seconds for 18% retention lift
- Pattern interrupts needed every 15-30 seconds
- Acceptable completion rate: 50-60%

## Supported Analysis Modes

1. **Quick Check** - Script snippet analysis with immediate fixes
2. **Deep Analysis** - Full 7-phase comprehensive review
3. **Comparison Mode** - Before/after version comparison
4. **Iterative Refinement** - Multi-round optimization tracking

## Example Usage

```
"I'm creating a 9-minute Photoshop tutorial. My intro is: 'Hey everyone,
welcome to my channel! Don't forget to subscribe...' Is this intro too
long? Where will I lose viewers? Give me specific recommendations."
```

## Research Sources

- 2025 Retention Rabbit Benchmark Report
- Vizard YouTube Intro Length Analysis
- Digital Media Lab 3-5 Second Rule Study
- Evolving Digital First 10 Seconds Guide
- TAGLAB Video Drop-off Rate Metrics
- Wistia Audience Retention Research
- Reelmind AI S.C.A.L.E. Framework
- Script Pacing Best Practices

---
Downloaded from [Find Skill.ai](https://findskill.ai)
