---
name: sponsorship-rate-calculator
version: 1.0.0
---

# Sponsorship Rate Calculator

Calculate brand sponsorship fees using actual engagement metrics, CPM rates, and audience demographics. Get data-backed pricing for YouTube, TikTok, Instagram, and podcast deals.

## Structure

- `SKILL.md` - Main skill prompt with complete CPM calculation framework, platform benchmarks, and negotiation strategies

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r sponsorship-rate-calculator/ ~/.claude/skills/sponsorship-rate-calculator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter (starting from "# Sponsorship Rate Calculator")
3. Paste into AI assistant (Claude, ChatGPT, Gemini, Copilot)
4. Share your platform, views, engagement rate, and audience demographics
5. Get calculated rates with minimum, standard, and premium tiers

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{avg_views_per_post}}` | `50000` | Median views from last 5-10 content pieces |
| `{{engagement_rate_percent}}` | `2.5` | Total engagements divided by impressions, times 100 |
| `{{geographic_premium_multiplier}}` | `1.0` | Audience location value (1.3x for 75%+ US/UK) |
| `{{niche_category}}` | `general_interest` | Content niche: finance, tech, beauty, gaming, etc. |
| `{{content_platform}}` | `youtube` | Primary platform: youtube, instagram, tiktok, podcast |

## What's Included

### Core Calculation Framework
- Platform-specific CPM benchmarks (YouTube, TikTok, Instagram, podcasts)
- Engagement rate tiers with multipliers (0-1%, 1-3%, 3-5%, 5-8%, 8%+)
- Geographic premium adjustments (US/UK vs. other markets)
- Niche-specific rate modifiers (finance 2x, gaming 0.7-0.9x, etc.)
- Age demographic value adjustments

### Pricing Models
- Flat fee calculation and structure
- CPM-based deals with caps and guarantees
- Performance-based (CPA/affiliate) structures
- Hybrid models combining guaranteed + upside

### Deliverable Pricing
- Content type multipliers (mention vs. dedicated vs. tutorial)
- Usage rights premiums (whitelisting, TV, perpetual)
- Exclusivity period pricing

### Negotiation Tools
- Three-tier rate card template
- Justification talking points
- Lowball offer responses
- Red flag identification

### Brand Vetting
- Research checklist
- Contract must-haves
- Warning signs to avoid

### Reference Data
- 2025 YouTube CPM by niche
- Influencer tier performance benchmarks
- Payment terms standards
- Common mistakes to avoid

## Example Usage

**Prompt:**
"I have 45,000 YouTube subscribers averaging 35,000 views per video with 7% engagement rate. My audience is 70% US/UK. A gaming peripheral company wants to sponsor a dedicated review video. What should I charge?"

**Expected Output:**
- Calculation showing base CPM ($15 gaming) adjusted for engagement (1.4x), geography (1.15x)
- Three-tier rate card: Minimum $1,200 / Standard $1,500 / Premium $2,200
- Negotiation talking points emphasizing high engagement
- Deal structure recommendation (flat fee or hybrid)

---
Downloaded from [Find Skill.ai](https://findskill.ai)
