---
name: niche-pivot-planner
version: 1.0.0
---

# Initialization

Strategic content transition planning for creators pivoting their niche without destroying their existing audience. Generate customized roadmaps, bridge content ideas, communication scripts, and risk assessments.

## Structure

- `SKILL.md` - Main skill prompt with complete niche pivot planning system

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r niche-pivot-planner/ ~/.claude/skills/niche-pivot-planner/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant as system prompt or context

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{current_niche}}` | `Gaming` | Your existing content focus |
| `{{new_niche}}` | `Tech Reviews` | The topic you want to transition to |
| `{{risk_tolerance}}` | `Medium` | Low (retain max followers), Medium, or High (fast change) |
| `{{platform}}` | `YouTube` | Primary platform (YouTube, Instagram, TikTok, LinkedIn, Blog) |
| `{{transition_speed}}` | `Moderate` | Slow (3-6 months), Moderate (1-2 months), or Instant |
| `{{brand_anchor}}` | `Honest analysis` | The element staying the same (humor, deep analysis, visual style) |

## Quick Start

After installation, try this prompt:

```
I currently create content about {{current_niche}} but want to pivot to {{new_niche}}.
My risk tolerance is {{risk_tolerance}}.

Please help me:
1. Assess the overlap between these niches
2. Generate 5 bridge content ideas
3. Create a transition timeline
4. Draft an announcement script
```

## Use Cases

1. **Bridge Content Strategy**: Generate video/post ideas that merge both niches
2. **Transition Planning**: Create week-by-week content ratio schedules
3. **Announcement Writing**: Draft authentic pivot announcements for video, social, or email
4. **Risk Assessment**: Calculate expected follower churn based on niche similarity
5. **Algorithm Recovery**: Plan for and minimize the "V-curve" engagement dip

## Key Concepts

- **Bridge Content**: Posts that incorporate elements of both old and new niche
- **Soft Pivot**: Gradual 8-16 week transition (lower risk, slower)
- **Hard Pivot**: Quick 2-3 week transition (higher risk, faster)
- **V-Curve**: Expected engagement dip during algorithm recalibration
- **Brand Anchor**: The constant element that survives the pivot (humor, style, values)

---
Downloaded from [Find Skill.ai](https://findskill.ai)
