---
name: media-kit-one-pager
version: 1.0.0
---

# Media Kit One-Pager Generator - Initialization

Create professional sponsorship pitch sheets that land brand deals. Generate media kits with metrics, demographics, rate cards, and case studies for podcasters, YouTubers, and content creators.

## What This Skill Does

Transforms raw creator data into professional, compelling one-page sponsorship documents by:
- Structuring media kits with industry-standard sections
- Generating platform-specific optimization (podcast, YouTube, Instagram, etc.)
- Creating rate cards based on industry benchmarks
- Building case studies from past partnerships
- Writing compelling value propositions and bios

## Structure

```
media-kit-one-pager/
├── SKILL.md   - Main skill prompt (copy to AI assistant)
└── INIT.md    - This initialization file
```

## Files to Generate

None required - this is a prompt-only skill.

## Post-Init Steps

### Claude Code
```bash
cp -r media-kit-one-pager/ ~/.claude/skills/media-kit-one-pager/
```

### ChatGPT / Gemini / Other AI Assistants
1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or initial message
4. Start by providing your creator details

## Quick Start

After installation, provide the AI with:
1. Your platform and content type (podcast, YouTube, Instagram, etc.)
2. Current metrics (followers, downloads, engagement rate)
3. Audience demographics (age, gender, location)
4. Your content niche
5. Past brand partnerships (if any)
6. Target sponsorship types

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{creator_name}}` | "Your Name" | Full name or creator brand name |
| `{{primary_niche}}` | "Content Creator" | Main content category or industry |
| `{{follower_count}}` | 50000 | Total followers across primary platform |
| `{{engagement_rate}}` | "4.5%" | Average engagement rate |
| `{{audience_demographics}}` | "25-44 (65%), Female (72%), 45% USA" | Key demographic breakdown |
| `{{sponsorship_tiers}}` | "Starter $500, Premium $1500, VIP $3000" | Pre-defined pricing levels |

## Example Usage

```
I'm a true crime podcast host with 85,000 monthly downloads. My audience
is primarily US listeners aged 35-54, 65% female. I've been podcasting
2x weekly for 3 years and have worked with Audible, MasterClass, and a
mattress brand. Generate a professional media kit one-pager I can send
to potential sponsors.
```

## Output Format

The skill generates media kits in a structured text format suitable for:
- Copy/paste into Canva or design tools
- Direct PDF export
- Sharing with brands as text

## Platform-Specific Features

| Platform | Key Metrics | Sponsorship Options |
|----------|-------------|---------------------|
| Podcast | Monthly downloads, completion rate | Pre-roll, mid-roll, host-read |
| YouTube | Subscribers, watch time % | Dedicated video, integration |
| Instagram | Followers, engagement rate | Feed post, Story, Reel |
| TikTok | Followers, engagement rate | Video mention, series |
| Newsletter | Subscribers, open rate | Dedicated email, mention |

## Industry Pricing Reference

| Tier | Follower Range | Rate/Placement |
|------|----------------|----------------|
| Nano | 1K-10K | $50-$250 |
| Micro | 10K-100K | $200-$1,000 |
| Mid-Tier | 100K-500K | $1,000-$5,000 |
| Macro | 500K-1M | $5,000-$10,000 |
| Mega | 1M+ | $10,000-$50,000+ |

## Best Practices

1. **Update quarterly** - Keep metrics current
2. **Engagement > followers** - Lead with engagement rate
3. **Platform-native analytics** - Use official stats, not estimates
4. **Visual demographics** - Charts work better than text
5. **PDF distribution** - Send links, not attachments
6. **Clear CTAs** - Email as primary contact method

## Troubleshooting

| Problem | Solution |
|---------|----------|
| Low follower count | Focus on engagement rate and niche value |
| No past partnerships | Highlight organic brand mentions and growth |
| Low engagement | Audit followers, highlight best content |
| Brands not responding | Personalize pitches, check spam filters |
| Unsure of pricing | Use industry benchmarks, start conservative |

## Recommended Tools

- **Canva** - DIY templates (Free-$120/yr)
- **CreatorsJet** - Auto-sync metrics (Free-$99/yr)
- **Pressdeck.io** - Press kit hosting ($50/yr)
- **Beacons** - All-in-one creator platform (Freemium)

---

Downloaded from [Find Skill.ai](https://findskill.ai)
