---
name: livestream-run-of-show
version: 1.0.0
---

# Livestream Run-of-Show Generator

Create detailed run-of-show documents for 30-minute livestreams with precise timing, segment planning, technical cues, and engagement checkpoints that keep viewers watching.

## Structure

```
livestream-run-of-show/
├── SKILL.md    # Main skill prompt (500+ lines)
└── INIT.md     # This file
```

## Files to Generate

None required - this is a prompt-only skill.

## Post-Init Steps

### Claude Code
```bash
# Copy to Claude Code skills directory
cp -r livestream-run-of-show/ ~/.claude/skills/livestream-run-of-show/
```

### ChatGPT / Gemini / Copilot
1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as instructions
4. Start with: "I need a run-of-show for my upcoming livestream"

### Custom GPT / Claude Project
1. Create new Custom GPT or Claude Project
2. Paste `SKILL.md` content as system instructions
3. Name it "Livestream Run-of-Show Generator"
4. Add description: "Creates professional production timelines for livestreams"

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{stream_duration}}` | `30` | Total stream length in minutes |
| `{{stream_type}}` | `entertainment` | Type: entertainment, educational, corporate, sales |
| `{{pattern_interrupt_interval}}` | `6` | Minutes between visual/content changes |
| `{{engagement_checkpoints}}` | `3` | Number of interactive moments |
| `{{content_segments}}` | `3` | Number of main content blocks |
| `{{has_guest}}` | `false` | Whether a guest joins mid-stream |

## Example Usage

```
I'm hosting a 30-minute YouTube live this Saturday covering "3 AI Tools That
Changed My Workflow." I want:
- A punchy hook that grabs viewers in the first 90 seconds
- Three 7-minute segments, one per tool
- A poll at the 15-minute mark
- Room for chat interaction
- A strong close with clear CTA to subscribe

Create a complete run-of-show with exact timestamps, camera/screen-share
cues, and backup content if I run short.
```

## Output Includes

1. **Stream Overview Header** - Title, date, duration, participants
2. **Pre-Stream Checklist** - Technical verification steps (T-30 to T-0)
3. **Main Timeline** - Minute-by-minute segment breakdown with technical cues
4. **Technical Cue Sheet** - Scene changes, graphics, audio cues with stand-by alerts
5. **Engagement Checkpoints** - Planned audience interactions
6. **Backup Content Plan** - Flex segments for timing adjustments
7. **Clip Markers** - Timestamps for post-stream editing (Shorts/TikTok/Reels)
8. **Post-Stream Tasks** - What to do immediately after ending

## Key Production Rules

- **60-120 Second Rule**: Hook must capture attention immediately
- **6-Minute Pattern Interrupt**: Change something visual every 6 minutes
- **15% Buffer**: Build flex time into each segment
- **80/20 Ratio**: 80% content, 20% CTAs and promotions

## Stream Type Templates

| Type | Structure |
|------|-----------|
| Entertainment | Hook → Content Block 1 → Poll → Content Block 2 → Surprise → Shoutouts → CTA |
| Educational | Hook → Prerequisites → Teaching 1 → Q&A → Teaching 2 → Recap → Resources |
| Corporate | Welcome → Problem → Customer Story → Demo → Pricing → Q&A |
| Sales | Cold Open → Pain Points → Testimonial → Demo → Offer → CTA |

## Troubleshooting

| Issue | Solution |
|-------|----------|
| Running long | Cut PAD segment, shorten close, skip one checkpoint |
| Running short | Extend PAD, add chat interaction, expand examples |
| Technical issues | Acknowledge, fill with chat, have backup segment ready |
| Low engagement | Increase checkpoint frequency, add polls |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
