---
name: bigger-creator-collab-pitch
version: 1.0.0
---

# Bigger Creator Collab Pitch - Initialization

Strategic framework for smaller creators to pitch collaborations with larger, established creators. Research targets, craft personalized pitches, build relationships, and negotiate partnerships that grow your audience.

## Structure

- `SKILL.md` - Main skill prompt with complete collaboration framework

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r bigger-creator-collab-pitch/ ~/.claude/skills/bigger-creator-collab-pitch/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant as system prompt or context

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{your_niche}}` | `productivity software` | Your content niche or industry focus |
| `{{your_follower_count}}` | `15000` | Your current audience size across platforms |
| `{{target_creator_size}}` | `100000-500000` | Follower range of creators you want to collaborate with |
| `{{collaboration_type}}` | `guest appearance` | Type of collaboration: guest appearance, content swap, joint project, podcast interview |
| `{{your_unique_value}}` | `deep technical expertise in automation` | What makes you valuable to larger creators |
| `{{engagement_days}}` | `7` | Days to engage with target's content before pitching |

## Quick Start

After loading the skill, start with:

```
I'm a [your niche] creator with [X followers] on [platform]. I want to
collaborate with [target creator name/type] who has around [X followers].
My unique angle is [what makes you valuable]. Help me create a strategy
to pitch them.
```

## Use Cases

1. **Creator Research**: Identify 15-20 potential collaboration targets with proper vetting
2. **Warm-Up Strategy**: 7-day engagement plan before any pitch
3. **Pitch Writing**: Custom outreach messages for email, DM, or LinkedIn
4. **Relationship Building**: Long-term nurturing strategies
5. **Negotiation**: Deal structure and compensation models
6. **Media Kit**: One-page pitch sheet for credibility
7. **Follow-Up**: Systematic follow-up framework

## Platform Coverage

- YouTube collaborations
- TikTok duets/stitches
- Podcast guest appearances
- Instagram Lives/Reels collabs
- Newsletter swaps

---
Downloaded from [Find Skill.ai](https://findskill.ai)
