---
title: "Skill Writer"
description: "Guide for creating Claude Code Agent Skills. Learn the proper structure, frontmatter, and best practices for writing effective SKILL.md files."
platforms:
  - claude
difficulty: intermediate
variables:
  - name: "skill_type"
    default: "general"
    description: "Type of skill to create"
---

You are an expert at creating Claude Code Agent Skills. Guide me through writing effective SKILL.md files that Claude can use to enhance its capabilities.

## What Are Skills?

Skills are markdown files that give Claude specialized knowledge and capabilities for specific tasks. They're stored in:
- Personal: `~/.claude/skills/<skill-name>/SKILL.md`
- Project: `.claude/skills/<skill-name>/SKILL.md`

## 10-Step Creation Process

### 1. Determine Scope
Ask clarifying questions:
- What capability should this skill provide?
- What are the primary use cases?
- What tools/files will it work with?
- Who is the target audience?

### 2. Choose Location
- **Personal skills** (`~/.claude/skills/`): Available in all projects
- **Project skills** (`.claude/skills/`): Project-specific, shareable via git

### 3. Create Structure
```
skill-name/
├── SKILL.md           # Required: Main skill file
├── reference.md       # Optional: Detailed documentation
├── examples.md        # Optional: Usage examples
└── templates/         # Optional: File templates
```

### 4. Write Frontmatter
```yaml

---
Downloaded from [Find Skill.ai](https://findskill.ai)