---
name: load-testing-plan-generator
version: 1.0.0
---

# Initialization

Design comprehensive load, stress, spike, and soak tests with proper metrics, tool selection, bottleneck analysis, and CI/CD integration for validating system performance under real-world conditions.

## Structure

- `SKILL.md` - Main skill prompt with complete load testing expertise

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r load-testing-plan-generator/ ~/.claude/skills/load-testing-plan-generator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{concurrent_users}}` | `100` | Number of simultaneous virtual users to simulate |
| `{{ramp_up_duration_seconds}}` | `300` | Time in seconds to reach target concurrency |
| `{{test_duration_minutes}}` | `10` | Total duration of steady-state load after ramp-up |
| `{{response_time_sla_ms}}` | `800` | Maximum acceptable P95 response time in milliseconds |
| `{{error_rate_threshold}}` | `0.005` | Maximum acceptable error rate as decimal (0.005 = 0.5%) |
| `{{think_time_ms}}` | `1000` | Simulated delay between user actions in milliseconds |

## Capabilities

This skill enables you to:

1. **Plan Load Tests** - Design test scenarios with realistic user behavior, workload distributions, and success criteria
2. **Select Tools** - Choose between k6, JMeter, Gatling, Locust, or other tools based on your tech stack
3. **Execute & Monitor** - Configure distributed load generation with real-time metrics collection
4. **Analyze Bottlenecks** - Identify CPU, memory, database, network, or cache constraints
5. **Interpret Metrics** - Understand P95/P99 percentiles, throughput, error rates, and SLA compliance
6. **CI/CD Integration** - Automate performance tests with regression detection in deployment pipelines
7. **Capacity Planning** - Calculate break-even points and optimal resource allocation

## Example Usage

```
Design a load test plan for our REST API that handles user authentication, product searches,
and order placement. We expect 5000 concurrent users during peak hours with 2000 requests/sec
throughput. Current SLA is P95 < 500ms. We use AWS with auto-scaling and want the test to run
in our CI/CD pipeline taking under 5 minutes. Use k6 since we're JavaScript-heavy.
```

## Load Test Types

| Type | Purpose | Typical Duration |
|------|---------|------------------|
| **Load Test** | Validate normal to peak performance | 5-15 minutes |
| **Stress Test** | Find breaking point | Until failure |
| **Spike Test** | Handle sudden traffic increases | 5-10 minutes at spike |
| **Soak Test** | Detect memory leaks | 2-24 hours |

## Key Metrics

- **P95 Response Time**: 95% of requests complete within this time
- **P99 Response Time**: 99% of requests (catches tail latency)
- **Throughput (RPS)**: Requests per second
- **Error Rate**: Failed requests as percentage
- **Saturation Point**: Where throughput plateaus

## Best Practices

1. Use realistic workloads from production logs
2. Focus on P95/P99 percentiles, not averages
3. Ramp up gradually (don't spike)
4. Validate with Little's Law: Concurrency = Throughput × Response Time
5. Test in production-like environment
6. Automate baseline comparisons for regression detection

---

Downloaded from [Find Skill.ai](https://findskill.ai)
