---
name: human-in-the-loop-patterns
version: 1.0.0
---

# Initialization

Design AI agents with human oversight that know when to pause, escalate, and request approval. Implement approval workflows, confidence-based routing, and graceful handoffs.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r human-in-the-loop-patterns/ ~/.claude/skills/human-in-the-loop-patterns/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{oversight_level}}` | `approval-required` | Degree of human oversight required |
| `{{escalation_channel}}` | `slack` | Where approvals are requested |
| `{{confidence_threshold}}` | `0.7` | Confidence level triggering human review |
| `{{timeout_behavior}}` | `pause-and-retry` | What happens if no human response |

---
Downloaded from [Find Skill.ai](https://findskill.ai)