---
name: feature-flag-strategy
version: 1.0.0
---

# Feature Flag Strategy - Initialization

Design and implement feature flag rollout strategies including canary releases, A/B testing, percentage rollouts, and lifecycle management for safe continuous delivery.

## Structure

```
feature-flag-strategy/
├── SKILL.md       # Main skill prompt (500+ lines)
└── INIT.md        # This initialization file
```

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code Installation
```bash
# Copy skill to Claude Code skills directory
cp -r feature-flag-strategy/ ~/.claude/skills/feature-flag-strategy/
```

### Other AI Assistants (ChatGPT, Gemini, Copilot)
1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or initial message
4. Begin designing your feature flag strategy

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{flag_name}}` | `feature/new-checkout-flow` | Unique identifier following naming convention `[type]/[domain]/[feature]` |
| `{{default_state}}` | `false` | Initial flag state before targeting rules apply |
| `{{rollout_percentage}}` | `0` | Percentage of users receiving the feature (0-100) |
| `{{target_segment}}` | `all_users` | User cohort: internal, beta, premium, geography-based |
| `{{environment}}` | `production` | Active environment: dev, staging, prod |
| `{{expiration_date}}` | `2025-12-31` | Auto-cleanup date triggering removal reminder |

## Capabilities

This skill enables you to:

1. **Design rollout strategies** - Percentage-based, canary, ring deployment, geographic
2. **Classify flag types** - Release, Experiment, Ops, Permissioning toggles
3. **Configure testing** - Environment-specific states, test matrices, overrides
4. **Manage lifecycle** - Expiration enforcement, automated cleanup, code removal
5. **Define targeting** - User attributes, segments, geographic regions
6. **Set monitoring** - Error rate thresholds, latency tracking, automatic rollback
7. **Integrate CI/CD** - Pipeline integration, version control workflows

## Example Usage

```
I'm launching a risky database query optimization that could impact latency.
Design a feature flag rollout strategy with:
- Canary release starting at 0.1%
- Automated rollback triggers if error rate exceeds 1%
- 2-week cleanup schedule
Include monitoring metrics and escalation thresholds.
```

## Output Format

The skill generates structured rollout plans:

```markdown
## Feature Flag Strategy: [Feature Name]

### Classification
- Type: [Release/Experiment/Ops/Permissioning]
- Risk Level: [Low/Medium/High]
- Expected Lifespan: [X days/weeks]

### Rollout Schedule
| Day | Percentage | Criteria to Proceed |
|-----|------------|---------------------|
| 0   | 0%         | Deploy code         |
| 1   | X%         | [Criteria]          |

### Success Metrics
- [Metric 1]: Target [value]
- [Metric 2]: Target [value]

### Rollback Triggers
- Automatic if [condition]
- Manual review if [condition]

### Cleanup Plan
- Expiration date: [Date]
- Removal assignee: [Person/Team]
```

## Related Skills

- **A/B Testing** - Statistical rigor for experiment toggles
- **Agent Observability & Monitoring** - Track rollout metrics
- **DevOps Expert** - CI/CD pipelines for flag-driven deployments
- **E2E Testing Patterns** - Test with flags enabled and disabled

## Tool Integrations

### Open Source
- Unleash, Flagsmith, GrowthBook, PostHog, Flipt, OpenFeature

### Commercial
- LaunchDarkly, Split, Statsig, Optimizely

## References

- [Feature Toggles - Martin Fowler](https://martinfowler.com/articles/feature-toggles.html)
- [How GitHub Ships Code Faster](https://github.blog/engineering/infrastructure/ship-code-faster-safer-feature-flags/)
- [Feature Flag Best Practices](https://octopus.com/devops/feature-flags/feature-flag-best-practices/)

---
Downloaded from [Find Skill.ai](https://findskill.ai)
