---
name: cpu-cache-hints
version: 1.0.0
---

# Initialization

Master CPU cache optimization and prefetching techniques from Google's performance guides by Jeff Dean and Sanjay Ghemawat. Reduce memory latency and boost throughput.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with cache optimization instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r cpu-cache-hints/ ~/.claude/skills/cpu-cache-hints/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, copilot, gemini

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{language}}` | `cpp` | Target programming language |

## Key Techniques Covered

### Data Structure Optimization
- Hot/cold field separation
- Memory layout optimization (struct packing)
- Padding reduction

### Container Selection
- Contiguous containers (vector, flat_hash_map)
- Inlined storage (InlinedVector, FixedArray)
- Avoiding pointer-rich structures

### Software Prefetching
- `__builtin_prefetch` usage and parameters
- Abseil's `PrefetchToLocalCache` API
- When to use vs. hardware prefetching

### Memory Patterns
- Structure of Arrays (SoA) vs Array of Structures (AoS)
- Bit vectors for small domains
- Index-based references vs pointers

### Profiling
- `perf stat` for cache metrics
- Interpreting cache miss ratios
- Identifying optimization candidates

## References

- [Abseil Performance Hints](https://abseil.io/fast/hints.html)
- [Abseil Performance Guide](https://abseil.io/fast/)
- [Memory Bandwidth Optimization (TotW #62)](https://abseil.io/fast/62)
- [GCC Data Prefetch Support](https://gcc.gnu.org/projects/prefetch.html)

## Attribution

Based on optimization techniques documented in Google's Abseil library guides, authored by Jeff Dean and Sanjay Ghemawat.

---
Downloaded from [Find Skill.ai](https://findskill.ai)
