---
name: revenge-quit-risk-assessor
version: 1.0.0
platforms:
  - claude
  - chatgpt
  - gemini
  - copilot
---

# Revenge Quit Risk Assessor - Initialization

Calculate if you can actually afford to rage-quit your job based on savings runway, market hire rates, job search duration, and financial safety buffers.

## Package Contents

```
revenge-quit-risk-assessor/
├── SKILL.md    # Main skill prompt (copy to AI assistant)
└── INIT.md     # This initialization file
```

## Structure

- `SKILL.md` - Complete skill prompt with all calculations, market data, and assessment logic

## Files to Generate

None required - this is a prompt-only skill that works immediately upon pasting into any AI assistant.

## Quick Start

### Claude Code Installation

```bash
# Copy skill to Claude Code skills directory
cp -r revenge-quit-risk-assessor/ ~/.claude/skills/revenge-quit-risk-assessor/
```

Then reference in your Claude Code session:
```
Use skill revenge-quit-risk-assessor
```

### ChatGPT / Claude.ai / Gemini / Copilot

1. Open `SKILL.md` in any text editor
2. Copy the entire content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or conversation
4. Start by describing your situation:
   - Current savings and monthly expenses
   - Current role and salary
   - Target role and location

## Example Usage

After activating the skill, try:

```
I'm a UX designer earning $75k at a corporate finance firm, completely
burned out. I have $35,000 saved, my rent is $2,200/month in Denver,
and total expenses run about $3,800/month including student loans.
Can I afford to rage-quit and find a new design job?
```

The AI will:
1. Calculate your savings runway (9.2 months)
2. Estimate job search duration for UX designers in Denver (4-6 months)
3. Generate an Affordability Score (92/100 - Safe to Quit)
4. Provide detailed recommendations and scenario analysis

## Variables

Customize the assessment by providing these values:

| Variable | Default | Description |
|----------|---------|-------------|
| `current_savings_usd` | 50000 | Total liquid savings for job transition |
| `monthly_expenses_usd` | 4000 | All monthly costs (rent, food, utilities, insurance, debt) |
| `target_role_type` | software_engineer | Job title for market rate and search duration lookup |
| `years_experience_in_role` | 3 | Years in current field |
| `job_search_urgency_level` | standard | Search intensity: aggressive, standard, passive |
| `location_cost_tier` | MCOL | Cost of living: LCOL, MCOL, or HCOL |

## Key Features

- **Savings Runway Calculator** - Months your savings can sustain expenses
- **Job Search Duration Estimator** - Role-specific timelines (2024-2025 data)
- **Financial Safety Gap Analysis** - Shortfall between savings and requirements
- **Affordability Score (0-100)** - "Can I Quit?" rating with risk level
- **Market Rate Reference** - Tech, business, and other role salaries by location
- **Income Bridge Strategies** - Freelance/contract options to extend runway
- **Scenario Analysis** - Optimistic, realistic, and conservative projections

## Score Interpretation

| Score | Rating | What It Means |
|-------|--------|---------------|
| 90-100 | Safe to Quit | Green light - proceed with confidence |
| 75-89 | Low Risk | Generally safe, minor concerns |
| 60-74 | Moderate Risk | Proceed with caution, have backup plan |
| 40-59 | High Risk | Not recommended, build more runway |
| 0-39 | Critical Risk | Do not quit without major changes |

## Job Search Duration Benchmarks

The skill uses 2024-2025 market data:

| Role Category | Entry Level | Mid Level | Senior |
|---------------|-------------|-----------|--------|
| Software Engineer | 3-5 mo | 3-6 mo | 4-8 mo |
| Product Manager | 4-6 mo | 4-6 mo | 5-8 mo |
| Marketing Manager | 5-7 mo | 5-7 mo | 6-9 mo |
| Finance Analyst | 4-6 mo | 4-8 mo | 6-10 mo |

## Troubleshooting

**"My role isn't in the benchmarks"**
- Provide your industry and role; the AI will estimate based on similar positions
- Consider whether your role is high-demand (shorter search) or niche (longer search)

**"I'm considering a career change"**
- Tell the AI your current role AND target role
- Career changes typically add 50-100% to search duration
- May need to accept 10-30% salary reduction initially

**"I have irregular income"**
- Provide average monthly expenses over last 6 months
- Include minimum debt payments as non-negotiable expenses
- Note any expected windfalls (tax refunds, bonus payouts)

## Research Sources

This skill synthesizes data from:
- 2024 employee surveys on workplace satisfaction and quit intentions
- r/Fire and r/financialindependence savings runway methodologies
- 2024-2025 salary data from r/datascience, r/marketing, r/codingbootcamp
- Job market analysis showing ~250 applicants per role, 3% interview rates
- Financial independence research on safe withdrawal rates and emergency buffers

## Related Skills

After assessing your quit readiness, consider:
- **Salary Negotiation Coach** - Negotiate higher offers for better post-hire runway
- **Career Pivot Risk Calculator** - Detailed analysis for industry/role changes
- **Resume Job Search Coach** - Optimize search to shorten job search duration
- **Budget Planner** - Reduce expenses to extend savings runway

---
Downloaded from [Find Skill.ai](https://findskill.ai)
