---
name: reference-check-prepper
version: 1.0.0
---

# Initialization

Reference Check Prepper is a strategic career skill that transforms the reference check phase from passive waiting into active management. It helps job candidates coach their references, align narratives with interviews, mitigate weaknesses, and handle damage control scenarios.

## Structure

- `SKILL.md` - Main skill prompt with complete reference check management system

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r reference-check-prepper/ ~/.claude/skills/reference-check-prepper/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter (everything after the second `---`)
3. Paste into AI assistant as a system prompt or custom instruction

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{target_role}}` | `Senior Product Manager at [Company]` | The job title and company being applied to |
| `{{reference_relationship}}` | `Former Manager` | Relationship type: Former Manager, Peer, Direct Report, Client |
| `{{key_wins_to_highlight}}` | `Q3 Migration Project` | Specific projects or metrics for reference to mention |
| `{{potential_weaknesses}}` | `Public speaking` | Areas that might come up negatively |
| `{{tone}}` | `Professional` | Communication style: Professional, Casual/Warm, Deferential |

## Core Workflows

### Workflow 1: The "Soft Ask" & Confirmation
Secure willing references before listing them:
1. Identify 4-5 potential references based on job requirements
2. Send warm-up emails to gauge willingness
3. Interpret responses (enthusiastic vs. hesitant vs. red flags)
4. Finalize confirmed list with contact details

### Workflow 2: The "Prep Packet" Deployment
Prepare references for success:
1. Trigger when you reach final rounds or get an offer
2. Create prep packet: Job description + Resume + Cheat Sheet
3. Schedule 10-minute briefing calls
4. Confirm logistics (phone, timezone, availability)

### Workflow 3: Damage Control
Handle problems that arise:
- Lukewarm reference feedback → Provide context, offer alternatives
- Radio silence from reference → Urgent follow-up, proactive substitution
- Known negative reference risk → Preemptive framing, counterbalance

## Key Concepts

- **Reference Sheet**: Document listing references with contact info and blurbs
- **Backchannel Reference**: Informal reference checks outside your official list
- **Qualified Privilege**: Legal protection for employers giving honest references
- **The "Cheat Sheet"**: Briefing document with talking points for references
- **Constructive Weakness**: Framing past struggles as growth opportunities
- **Radio Silence**: When a reference ghosts the recruiter (major red flag)

## Example Usage

```
User: I'm applying for a Senior Product Manager role at Google that
emphasizes 'Stakeholder Management' and 'Agile methodologies.' Please
draft an email to my former boss, Sarah, along with a 'cheat sheet'
that reminds her of how I handled the difficult client during the Zeta
launch and how I introduced Sprint planning to the team.
```

## Target Audience

- **Mid-to-Senior Professionals**: Complex work histories needing curated narratives
- **Career Coaches**: Advising clients through high-stakes background checks
- **Freelancers/Consultants**: Verifying project success through client testimonials
- **Career Changers**: Highlighting transferable skills through references

## Best Practices

**DO:**
- Provide references with the exact job description
- Refresh their memory with specific projects and dates
- Ask "Are you comfortable giving me a strong reference?"
- Give bullet points, not full scripts
- Confirm logistics before listing anyone

**DON'T:**
- Blindside a reference (always confirm first)
- Over-script responses (they'll sound robotic)
- Use references who are hesitant
- Wait until deadline to follow up on silence
- Assume HR will give a real reference

---
Downloaded from [Find Skill.ai](https://findskill.ai)
