---
name: promotion-case-builder
version: 1.0.0
---

# Initialization

Build a compelling promotion case with weekly win tracking, impact metrics documentation, and quarterly narrative assembly. This skill transforms scattered achievements into promotion-ready portfolios through systematic documentation.

## Structure

- `SKILL.md` - Main skill prompt with templates, workflows, and best practices

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code

```bash
cp -r promotion-case-builder/ ~/.claude/skills/promotion-case-builder/
```

Then reference in conversations:
```
Use the promotion-case-builder skill to help me document this week's wins
```

### ChatGPT / Gemini / Copilot

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into a new conversation or custom instructions
4. Start with: "Help me set up my promotion case tracking system"

### Quick Start Prompts

**Initial Setup:**
```
I want to start building my promotion case. I'm a [current role] aiming for [target role] with a promotion cycle in [X months]. Help me set up my tracking system.
```

**Weekly Win Logging:**
```
Help me document this week's wins. This week I [describe 2-3 accomplishments]. Format these using the weekly win template.
```

**Quarterly Assembly:**
```
I have [X] weekly wins from this quarter. Help me identify themes and synthesize them into 3-5 case stories for my promotion narrative.
```

**Year-End Case:**
```
I need to assemble my promotion case. I have quarterly summaries for Q1-Q4. Help me create the final promotion document structure.
```

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{tracking_frequency}}` | `weekly` | How often to log wins |
| `{{quarterly_review_month}}` | `3, 6, 9, 12` | When to compile quarterly narratives |
| `{{promotion_timeline}}` | `12-18 months` | Expected evidence-gathering timeframe |
| `{{impact_metric_types}}` | `revenue, efficiency, users, speed, quality` | Categories for quantifying impact |
| `{{stakeholder_sample_size}}` | `3-5` | Number of stakeholders for quarterly feedback |
| `{{narrative_length_words}}` | `300-500` | Target word count per case story |
| `{{evidence_retention_duration}}` | `24 months` | How long to keep supporting materials |

## Key Templates Included

1. **Weekly Win Template** - Structured format for capturing achievements with STAR elements
2. **Stakeholder Tracking Template** - Track who can vouch for your contributions
3. **Quarterly Case Story Template** - 300-500 word narrative format
4. **Quarterly Summary Template** - 1-page visual summary with metrics
5. **Promotion Case Structure** - 5-10 page final document outline
6. **STAR Story Template** - Interview-ready story format
7. **Competency-to-Story Index** - Map stories to key competencies

## Recommended Workflow

1. **Week 1**: Set up folder structure and complete initial assessment
2. **Weekly**: 15-minute win logging session (Friday or Monday)
3. **Monthly**: Review and tag evidence, update stakeholder map
4. **Quarterly**: 1-2 hour narrative assembly session
5. **Mid-Year**: Extended manager conversation + gap analysis
6. **Year-End**: Final case assembly (4-6 hours total)

## Integration Tips

- Pair with **Performance Review Generator** for self-assessment prep
- Use **Salary Negotiation Coach** when leveraging documented wins for compensation
- Connect with **Interview Prep Simulator** to practice STAR stories

---
Downloaded from [Find Skill.ai](https://findskill.ai)
