---
name: mentor-network-builder
version: 1.0.0
---

# Initialization

Build and manage a strategic portfolio of mentors using mosaic mentoring principles. This skill helps you discover ideal mentors, craft compelling outreach, and cultivate multiple relationships for comprehensive career development.

## Structure

- `SKILL.md` - Main skill prompt with comprehensive mentor network building guidance

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r mentor-network-builder/ ~/.claude/skills/mentor-network-builder/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter (everything after the second `---`)
3. Paste into AI assistant as system prompt or custom instructions

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{mentorship_frequency}}` | `monthly` | How often mentor-mentee meetings occur (weekly, biweekly, monthly, quarterly) |
| `{{mentee_readiness_level}}` | `intermediate` | Current career stage (early_career, intermediate, senior_transitioning) |
| `{{mentoring_type}}` | `mosaic` | Relationship structure (dyadic, peer, reverse, group, mosaic) |
| `{{mentorship_duration}}` | `6_months` | Expected engagement length (3_months, 6_months, 12_months, ongoing) |
| `{{mentor_matching_priority}}` | `values_alignment` | Primary selection criterion (expertise, values_alignment, accessibility, diversity_perspective) |
| `{{feedback_style_preference}}` | `direct_supportive` | Preferred feedback approach (direct_blunt, direct_supportive, gradual_questioning, collaborative) |

## Core Capabilities

This skill helps you:

1. **Mentor Discovery & Mapping** - Systematically identify potential mentors across your network tiers (warm, weak, aspirational connections)

2. **Compelling Outreach** - Craft personalized messages for warm, weak-tie, and cold outreach with proven templates

3. **Mosaic Mentor Networks** - Build multi-mentor portfolios with different mentors for technical, leadership, industry, peer, and sponsor needs

4. **Multi-Mentor Management** - Coordinate multiple relationships with tracking dashboards and health indicators

5. **Relationship Repair** - Diagnose stalled relationships and use reset conversations or graceful exit protocols

6. **Mentee Readiness** - Self-assess your readiness and prepare effectively for mentoring relationships

## Key Concepts

- **Mosaic Mentoring**: Multiple mentors simultaneously addressing different developmental needs
- **Kram's Phases**: Initiation → Cultivation → Separation → Redefinition lifecycle
- **Supplementary vs Complementary Fit**: Similarity-based vs. gap-filling mentor matching
- **Sponsor vs Mentor**: Advisors who guide vs. advocates who create opportunities

## Example Usage

"I'm a product manager with 3 years of experience looking to transition into a director role within 18 months. I don't have any mentors currently and feel stuck in my career growth. Help me identify what types of mentors I need, create a strategy for finding and approaching potential mentors, and build a system for managing multiple mentor relationships."

## Research Sources

- NIH Optimizing Mentoring Relationship Toolkit
- Building and Sustaining Mentor Interactions (PMC)
- Zapier Guide to Finding Mentors
- TogetherPlatform Mentoring Framework
- MentorCliq Best Practices
- Art of Mentoring Self-Assessment Tools
- 2025 Mentoring Platform Comparisons

---
Downloaded from [Find Skill.ai](https://findskill.ai)
