---
name: identity-exploration-prompt
version: 1.0.0
---

# Initialization

Generate customized, thought-provoking questions to discover your authentic identity across career, values, life purpose, and personal domains through structured introspection.

## Structure

- `SKILL.md` - Main skill prompt with identity exploration framework

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r identity-exploration-prompt/ ~/.claude/skills/identity-exploration-prompt/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{focus_area}}` | `all` | Domain to explore: career, values, life_purpose, strengths, relationships, life_domains, or all |
| `{{exploration_depth}}` | `moderate` | Question intensity: shallow (surface-level), moderate (balanced), deep (soul-searching) |
| `{{user_stage}}` | `exploring` | Identity journey phase: just_starting, exploring, committing, in_transition |
| `{{question_style}}` | `mixed` | Cognitive approach: reflective, analytical, future_focused, experience_based, intuitive, or mixed |
| `{{question_count}}` | `10` | Number of questions to generate (5-50) |

## Quick Start Examples

### Career Identity Discovery
```
Generate 8 career identity questions for someone transitioning from finance to nonprofit work.
Focus on strengths, motivations, values, and integration into a career identity statement.
Use moderate depth and personalize to their finance background.
```

### Values Clarification
```
Help me clarify my core values with 12 deep questions.
Include questions about value origins, prioritization, and alignment between stated and lived values.
I'm actively exploring and want a workshop-style format.
```

### Life Purpose Exploration
```
I'm navigating a major life transition (new city, career change, relationship ending).
Generate 15 questions using mixed styles to help me discover my life purpose.
Honor the difficulty of transition while exploring passions, impact, and meaning.
```

### Limiting Beliefs Challenge
```
Generate 7 compassionate questions to help me identify and challenge limiting beliefs.
I know self-doubt is holding me back but haven't articulated specific beliefs.
Start shallow and build to moderate depth. Focus on origin and transformation.
```

## Core Workflows

1. **Career Identity Discovery** - Create authentic career identity statement from strengths, motivations, values
2. **Values Clarification** - Identify, prioritize, and align life with core personal values
3. **Life Purpose Discovery** - Clarify meaningful direction and desired impact
4. **Limiting Beliefs Challenge** - Uncover and transform constraining beliefs
5. **Life Domain Exploration** - Holistic examination across all life dimensions

## Key Frameworks Referenced

- **Marcia's Identity Status Model** - Exploration + Commitment dimensions
- **Career Identity Framework** - Strengths, Motivations, Values as North Star
- **Values Clarification Methodology** - Stated vs. Lived values, value hierarchy
- **Peak Experience Analysis** - Mining fulfillment moments for purpose clues
- **Limiting Beliefs Architecture** - Origin, Trigger, Cost, Payoff, Alternative

---

Downloaded from [Find Skill.ai](https://findskill.ai)
