---
name: employment-gap-storyteller
version: 1.0.0
---

# Employment Gap Storyteller - Initialization

Transform employment gaps caused by burnout, depression, or mental health challenges into compelling career narratives that position your break as professional growth.

## Package Structure

```
employment-gap-storyteller/
├── SKILL.md          # Main skill prompt (copy to AI assistant)
├── INIT.md           # This initialization file
└── index.md          # Hugo page file (for website only)
```

## Files to Generate

None required. This is a prompt-only skill.

## Quick Start

### Claude Code Installation

```bash
# Copy skill to Claude Code skills directory
cp -r employment-gap-storyteller/ ~/.claude/skills/employment-gap-storyteller/
```

Then reference in your conversation: "Use the employment-gap-storyteller skill to help me craft my career narrative."

### Other AI Assistants (ChatGPT, Gemini, Copilot)

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or at the start of a conversation

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `gap_duration_months` | `6` | Length of employment break in months |
| `gap_reason` | `burnout` | Primary reason: burnout, depression, anxiety, family_care, health, layoff, career_transition |
| `role_level` | `mid-level` | Career stage: junior, mid-level, senior, executive |
| `company_culture_type` | `startup` | Target company: corporate, startup, non-profit, creative |
| `disclosure_comfort_level` | `moderate` | Detail level: minimal, moderate, transparent |
| `gap_activities` | `wellness focus, skill building, reflection` | Activities during gap period |

## Example Prompts

**Basic Usage:**
```
I took 6 months off after burning out in my corporate marketing role.
Help me craft a narrative for interviewing at startups.
```

**Detailed Context:**
```
I'm a senior software engineer who took 9 months off due to depression
after a failed project. I'm interviewing for a Principal Engineer role
at an established tech company. I completed some open source contributions
and technical courses during my break. Help me develop my gap narrative
and 3 STAR stories that incorporate lessons from this experience.
```

**Cover Letter Help:**
```
I need a cover letter opening that addresses my 6-month career break
proactively. The company values work-life balance and psychological
safety. My break was for burnout recovery and I did leadership coaching
during the time off.
```

## What This Skill Helps With

1. **Narrative Reframing** - Transform "I had a breakdown" into "I took a strategic sabbatical"
2. **STAR Story Development** - Create 5-7 interview stories with gap-integrated options
3. **Resume Optimization** - Add professional gap sections that build credibility
4. **LinkedIn Updates** - Craft About sections and sabbatical entries
5. **Cover Letters** - Proactive gap explanations that control the narrative
6. **Confidence Building** - Mindset reframes and anchor statements
7. **Interview Prep** - Handle difficult questions about the gap

## Key Frameworks Included

- **Strategic Language Transformation Table** - Convert vulnerable language to professional framing
- **Growth Bridge Template** - Connect gap experience to professional value
- **Three Gap Section Resume Formats** - Options for different comfort levels
- **Three STAR Story Types** - Recovery from setback, self-awareness, values clarification
- **Mindset Reframes Table** - Transform self-defeating thoughts
- **Pre-Interview Checklist** - 5-step confidence routine

## Success Criteria

You've completed the skill workflow when you have:
- [ ] 30-60 second gap narrative that feels natural
- [ ] 2-3 credible activities to mention from your gap
- [ ] 5-7 STAR stories with 2-3 gap-integrated
- [ ] Updated resume with gap explanation
- [ ] LinkedIn About section with gap context
- [ ] Cover letter template with proactive framing
- [ ] Confidence anchor statement memorized
- [ ] Answers ready for difficult questions

## Related Skills

- **Resume & Job Search Coach** - Complete job search coaching
- **Interview Prep Simulator** - STAR method practice
- **Career Pivot Risk Calculator** - Transition planning
- **Breaking Point Recovery Plan** - Burnout recovery strategies
- **LinkedIn Profile Optimizer** - Professional profile optimization

---
Downloaded from [Find Skill.ai](https://findskill.ai)
