---
name: counter-offer-decline-scripts
version: 1.0.0
---

# Counter-Offer Decline Scripts - Initialization

Professional scripts and decision frameworks for confidently declining counter-offers from your current employer when transitioning to a new role.

## What This Skill Does

This skill transforms your AI assistant into a career transition coach specializing in counter-offer situations. It provides:

- **Manipulation Tactic Recognition** - Identify the four primary employer retention strategies
- **Statistical Grounding** - Data showing why 50-90% who accept counter-offers leave within 12 months
- **Professional Scripts** - Word-for-word decline templates for various scenarios
- **Objection Handling** - Responses for common pushback ("What would make you stay?")
- **Industry-Specific Advice** - Tailored guidance for tech, creative, freelance, and sponsorship contexts
- **Exception Assessment** - Framework for evaluating rare situations where counter-offers merit consideration

## Package Structure

```
counter-offer-decline-scripts/
├── SKILL.md    # Main skill prompt (copy into AI assistant)
└── INIT.md     # This file - setup instructions
```

## Files to Generate

None required. This is a prompt-only skill.

## Installation

### Claude Code

```bash
# Copy skill to Claude Code skills directory
cp -r counter-offer-decline-scripts/ ~/.claude/skills/counter-offer-decline-scripts/
```

Then reference in conversations:
```
Use the counter-offer decline scripts skill to help me decline a counter-offer professionally.
```

### ChatGPT / Gemini / Copilot

1. Open `SKILL.md`
2. Copy all content after the frontmatter (starting from "# Counter-Offer Decline Scripts")
3. Paste as your first message or in Custom Instructions
4. Follow with your specific counter-offer situation

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{notice_period_days}}` | `14` | Days of notice to provide (14=US standard, 30=EU/senior) |
| `{{counter_offer_delay_hours}}` | `48` | Hours to request before responding to counter-offer |
| `{{new_company_name}}` | `[New Company]` | Name of the company you're joining |
| `{{current_manager_name}}` | `[Manager Name]` | Your current manager's name |
| `{{bridge_burning_threshold}}` | `diplomatic` | Tone: diplomatic, balanced, or direct |
| `{{industry_context}}` | `corporate` | Context: corporate, tech, creative, freelance, sponsorship |

## Quick Start Example

After installing, try this prompt:

```
I just resigned from my tech company and received a counter-offer: 25% raise,
$30K signing bonus, and "fast-track to Senior Manager" within 6 months.

The new job I accepted is fully remote (current is RTO 3x/week) and pays
10% more base with equity. My manager seemed hurt and said the team needs me.

Help me decline professionally without burning bridges.
```

## Key Scripts Included

1. **The Graceful Professional** - Standard decline with gratitude
2. **The Firm but Brief** - When you need to shut down repeated asks
3. **The "It's Not About Money"** - Emphasizing non-compensation factors
4. **The Repeated Ask Deflector** - Handling persistent pressure
5. **The Delay Request** - Buying time without committing

## Related Skills

- [Salary Negotiation Coach](/skills/productivity/salary-negotiation-coach/) - Negotiate before you have to decline
- [Job Offer Comparison Tool](/skills/productivity/job-offer-comparison-tool/) - Compare multiple offers systematically
- [Career Values Clarifier](/skills/productivity/career-values-clarifier/) - Understand what matters beyond money

---
Downloaded from [Find Skill.ai](https://findskill.ai)
