---
name: career-pivot-simulator
version: 1.0.0
---

# Career Pivot Simulator - Initialization

Model the financial impact of switching careers with quantitative projections for year-1 salary dip, 5-year cumulative gains, break-even analysis, and credential/location optimization.

## What This Skill Does

The Career Pivot Simulator helps professionals answer: "If I switch to [Field], what is the 1-year salary dip and 5-year gain?" It provides:

- **Salary Impact Calculator**: Compute immediate reduction when pivoting (15-30% typical)
- **5-Year ROI Projection**: Model total earnings and recovery trajectory
- **Break-Even Analysis**: Find the exact month when pivot financially pays off
- **Credential Impact Modeling**: Compare bootcamp vs. degree vs. self-taught ROI
- **Multi-Scenario Comparison**: Side-by-side analysis of multiple pivot targets
- **Location Optimization**: Geographic arbitrage for real purchasing power
- **Financial Runway Assessment**: Risk evaluation based on savings and runway

## Package Structure

```
career-pivot-simulator/
├── SKILL.md          # Main skill prompt (copy this to use)
├── INIT.md           # This initialization file
└── career-pivot-simulator.zip  # Downloadable package
```

## Files to Generate

None required - this is a prompt-only skill. The complete functionality is contained in SKILL.md.

## Installation

### Claude Code / Claude Desktop

```bash
# Option 1: Copy to Claude Code skills directory
cp -r career-pivot-simulator/ ~/.claude/skills/career-pivot-simulator/

# Option 2: Add to project-specific skills
cp -r career-pivot-simulator/ .claude/skills/career-pivot-simulator/
```

### ChatGPT / Gemini / Copilot / Other AI Assistants

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or custom instructions
4. Start a new conversation to activate

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{current_salary}}` | `$85,000` | Your current annual total compensation |
| `{{target_field}}` | `data science` | The career field you're considering |
| `{{years_experience}}` | `7` | Years of professional experience |
| `{{location_preference}}` | `remote` | Target location: city name or "remote" |
| `{{credential_plan}}` | `bootcamp` | Training approach: bootcamp, degree, self-taught, none |
| `{{financial_runway_months}}` | `12` | Months of expenses covered by savings |

## Quick Start Examples

### Basic Pivot Simulation
```
I'm a marketing manager making $95K with 6 years experience. Considering switching to product management. What's my financial trajectory?
```

### Credential Comparison
```
Should I do a data science bootcamp ($15K, 4 months) or just self-teach? I currently make $80K in operations. Compare the ROI.
```

### Multi-Field Analysis
```
I make $120K as a software engineer but want to switch careers. Compare pivoting to: (1) Product Management, (2) UX Design, (3) Data Science. Which has the best 5-year ROI?
```

### Location Optimization
```
I'm in NYC making $150K as a financial analyst. If I pivot to data science and go remote to Austin or stay in NYC, which is better financially?
```

## Key Outputs

The skill generates structured reports including:

1. **Year 1 Salary Impact Report**
   - Current vs. target compensation breakdown
   - Percentage dip calculation
   - Factors applied (COLA, transferable skills, credentials)

2. **5-Year Trajectory Comparison**
   - Year-by-year projection table
   - Visual trajectory chart
   - Cumulative difference calculation

3. **Break-Even Analysis**
   - Transition costs itemized
   - Monthly cumulative crossover tracking
   - Exact break-even month identification

4. **Recommendation Summary**
   - GO / CAUTIOUS GO / WAIT / NO-GO verdict
   - Key risk factors
   - Optimization opportunities

## Data Sources Referenced

The skill draws on benchmarks from:
- Bureau of Labor Statistics (BLS) Occupational Outlook Handbook
- Levels.fyi compensation data
- Glassdoor salary estimates
- O*NET career pathways
- Industry-specific growth rate research

## Related Skills

- **Career Pivot Risk Calculator** - Assess go/no-go feasibility first
- **Skill Transferability Mapper** - Map existing skills to new fields
- **Salary Negotiation Coach** - Negotiate experienced-hire premium
- **Personal Budget Coach** - Build financial runway for pivot

## Post-Installation Verification

Test the skill with this prompt:
```
I'm a senior accountant making $75K with 5 years experience in Ohio. Considering pivoting to data analyst. I have $40K saved and $3K monthly expenses. Run a career pivot simulation.
```

Expected output: Detailed analysis showing ~20-25% salary dip, break-even around month 24-30, and positive 5-year ROI.

---
Downloaded from [Find Skill.ai](https://findskill.ai)
