---
name: tiktok-content-strategy-architect
version: 1.0.0
---

# Initialization

TikTok Content Strategy Architect - Design algorithm-optimized TikTok content strategies for discovery, engagement, and monetization through short-form vertical video.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive TikTok strategy instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r tiktok-content-strategy-architect/ ~/.claude/skills/tiktok-content-strategy-architect/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (everything below the second `---`)
3. Paste into your AI assistant's system prompt or custom instructions

## Compatibility

Tested with: Claude, ChatGPT, Gemini, Copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{posting_frequency_per_week}}` | `5` | Number of videos to publish weekly |
| `{{target_completion_rate_percentage}}` | `70` | Goal for video completion rate |
| `{{micro_niche_focus_percentage}}` | `85` | Percentage of niche-specific content |
| `{{engagement_rate_target_percentage}}` | `6.5` | Target engagement rate |
| `{{trend_content_mix_percentage}}` | `40` | Percentage of trending vs evergreen content |

## Core Capabilities

1. **Micro-Niche Audience Targeting** - Identify and build strategy for specific niche communities
2. **Hook & Pattern Interrupt Design** - Master first 2-second scroll-stopping techniques
3. **Trending Sound & Hashtag Strategy** - Research, predict, and leverage viral trends early
4. **Algorithm Signal Optimization** - Structure content for watch time, completion rate, engagement
5. **Interactive Feature Leverage** - Design Duets, Stitches, Comments, and Hashtag Challenges
6. **Monetization Path Architecture** - Build strategy for Creator Fund and revenue diversification
7. **Cross-Platform Content Repurposing** - Adapt content for YouTube Shorts, Instagram Reels

## Research Sources

This skill was built using research from:
- TikTok Creative Center (Official)
- Hootsuite TikTok Algorithm Guide
- TikTok Creator Fund Requirements
- Industry best practices for short-form video content

---
Downloaded from [Find Skill.ai](https://findskill.ai)
