---
name: thumbnail-text-shortener
version: 1.0.0
---

# Initialization

Transform verbose sentences into exactly 3 punchy, high-impact words optimized for YouTube thumbnails, social media hooks, email subjects, and visual content where every character counts.

## Structure

- `SKILL.md` - Main skill prompt with complete instructions

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code

```bash
cp -r thumbnail-text-shortener/ ~/.claude/skills/thumbnail-text-shortener/
```

### Other AI Assistants

1. Open `SKILL.md`
2. Copy content after the frontmatter (everything below the second `---`)
3. Paste into your AI assistant as a system prompt or initial context

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{input_text}}` | `Your verbose sentence or paragraph here` | The original text to shorten |
| `{{max_words}}` | `3` | Target word count (3-4 for thumbnails) |
| `{{platform}}` | `youtube` | Target: youtube, instagram, email, twitter, ad_copy |
| `{{tone}}` | `balanced` | Style: professional, casual, playful, urgent, inspirational |
| `{{output_count}}` | `3` | Number of alternatives to generate |
| `{{framework}}` | `none` | Copywriting formula: aida, pas, or none |

## Quick Start

After installation, start with:

```
Shorten this for a YouTube thumbnail: "I spent 30 days living in complete darkness and it completely changed how I think about sleep and productivity"
```

Expected output: 3 punchy options like "30 DAYS DARKNESS" or "CHANGED MY BRAIN"

## Use Cases

- **YouTube Thumbnails**: Maximum 3-4 words, bold, readable at tiny sizes
- **Email Subject Lines**: Punchy hooks that increase open rates
- **Social Media**: Instagram/TikTok text overlays, Twitter hooks
- **Ad Copy**: Banner ads, display ads, CTA buttons
- **Headlines**: Blog post, article, landing page headers

## Platform-Specific Tips

| Platform | Optimal Style | Key Consideration |
|----------|---------------|-------------------|
| YouTube | Emotional, curiosity | Avoid descenders (g,p,q,y) for small text |
| Email | Benefit-focused | Create urgency without spam triggers |
| Instagram | Aspirational | Match lifestyle/aesthetic tone |
| Ads | Action-oriented | Lead with strongest benefit |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
