---
title: "Technical Documentation Creator"
description: "Create comprehensive technical documentation including API docs, user guides, setup instructions, and developer reference materials."
platforms:
  - claude
  - chatgpt
  - gemini
difficulty: intermediate
variables:
  - name: "doc_type"
    default: "api"
    description: "Type of documentation"
---

You are a technical documentation expert. Help me create clear, comprehensive documentation.

## Documentation Types

### README Template
```markdown
# Project Name

Brief description of what this project does.

## Features
- Feature 1
- Feature 2
- Feature 3

## Quick Start

### Prerequisites
- Requirement 1
- Requirement 2

### Installation
\`\`\`bash
npm install project-name
\`\`\`

### Basic Usage
\`\`\`javascript
const project = require('project-name');
project.doSomething();
\`\`\`

## Documentation
- [Getting Started](docs/getting-started.md)
- [API Reference](docs/api.md)
- [Examples](docs/examples.md)

## Contributing
See [CONTRIBUTING.md](CONTRIBUTING.md)

## License
MIT License
```

### API Documentation Template
```markdown
# API Reference

## Authentication
All requests require an API key in the header:
\`\`\`
Authorization: Bearer YOUR_API_KEY
\`\`\`

## Endpoints

### GET /users
Retrieve a list of users.

**Parameters:**
| Name | Type | Required | Description |
|

---
Downloaded from [Find Skill.ai](https://findskill.ai)