---
name: shareable-aesthetic-prompts
version: 1.0.0
---

# Shareable Aesthetic Prompts - Initialization

Create high-taste, scroll-stopping visual prompts for Pinterest, Instagram, and TikTok. Master the 4-layer prompt architecture for shareable lifestyle, food, home, and portrait content.

## Package Structure

```
shareable-aesthetic-prompts/
├── SKILL.md      # Main skill prompt (copy to your AI assistant)
└── INIT.md       # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill.

## Post-Installation Steps

### For Claude Code Users

```bash
# Copy the skill to your Claude Code skills directory
cp -r shareable-aesthetic-prompts/ ~/.claude/skills/shareable-aesthetic-prompts/
```

Then reference the skill in conversations:
```
Use the shareable-aesthetic-prompts skill to create Instagram content for my home decor account.
```

### For ChatGPT / GPT-4 Users

1. Open `SKILL.md` in this package
2. Copy all content after the frontmatter (everything below the `---` markers)
3. Start a new conversation and paste the skill as a system prompt
4. Or create a Custom GPT with the skill content

### For Claude.ai (Web) Users

1. Open `SKILL.md` in this package
2. Copy all content after the frontmatter
3. Create a new Project and paste as Project Instructions
4. Or paste at the start of a conversation

### For Gemini Users

1. Open `SKILL.md` in this package
2. Copy all content after the frontmatter
3. Paste at the start of your conversation
4. Or use in Gemini Gems as instructions

### For Copilot Users

1. Open `SKILL.md` in this package
2. Copy all content after the frontmatter
3. Paste as context at the start of your chat

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{content_category}}` | `lifestyle` | Type of visual content (portrait, food, home, lifestyle, selfie) |
| `{{platform}}` | `instagram` | Target social platform (pinterest, instagram, tiktok) |
| `{{lighting_mood}}` | `golden hour warm` | Lighting and atmosphere preference |
| `{{color_palette}}` | `warm neutrals` | Color scheme for the image |
| `{{composition_style}}` | `rule of thirds` | Framing and composition approach |

## Quick Start Examples

### Home Decor Content
```
I need prompts for cozy Scandinavian living room photos for Pinterest.
Focus on golden morning light and warm neutral tones.
```

### Food Photography
```
Create 5 prompts for overhead flat-lay food photography.
Mediterranean cuisine, warm earth tones, magazine editorial style.
```

### Editorial Portraits
```
Generate prompts for fashion editorial portraits.
Vogue aesthetic, soft directional lighting, minimal backgrounds.
```

### Lifestyle/Wellness
```
I need Instagram content for a wellness account.
Serene bedroom moments, morning light, peaceful atmosphere.
```

## Core Concepts

### The 4-Layer Prompt Architecture

1. **Layer 1: Context/Scene Setting** - Concrete, relatable imagery (most important)
2. **Layer 2: Visual Treatment** - Photography style, lighting, mood
3. **Layer 3: Detail Enhancement** - Colors, textures, composition
4. **Layer 4: Polish** - References, quality modifiers (least important)

### The Shareability Test

Before using any prompt, ask: "Would this stop someone from scrolling?"

**High-shareability factors:**
- Relatability (people recognize and want this)
- Warmth (inviting palette, soft lighting)
- Clear composition (focal point, pleasing arrangement)
- Aspiration (elevated but achievable)

### Key Lighting Terms

| Term | Best For |
|------|----------|
| Golden hour | Portraits, outdoor, evening content |
| Window light | Portraits, interiors, lifestyle |
| Rim light | Dramatic portraits, artistic images |
| Top lighting | Food photography, flat-lays |
| Soft/diffused | Beauty, editorial, intimate moments |

## Supported Content Categories

1. **Editorial Portraits** - Magazine-worthy headshots and fashion
2. **Home Decor** - Interior design inspiration
3. **Food Photography** - Recipe and culinary content
4. **Selfies/Personal** - Casual luxury aesthetic
5. **Lifestyle/Wellness** - Self-care and mindfulness

## Common Mistakes to Avoid

1. Starting with vague descriptors ("beautiful", "nice")
2. Using technical camera jargon (f-stops, ISO)
3. Mixing contradictory aesthetics (documentary + editorial)
4. Abstract concepts as subjects (use concrete nouns)
5. Over-specificity on minor details (brand names)

## Troubleshooting

**Images look too technical/benchmark-like?**
- Remove "8K", "hyperrealistic", camera settings
- Focus on emotional descriptors and relatable scenes

**Images feel cold or clinical?**
- Add warm lighting descriptors (golden, tungsten, warm)
- Include texture hints (linen, wood, cotton)

**Composition feels off?**
- Specify angle and framing explicitly
- Add negative space direction
- Use "rule of thirds" or "centered with depth"

**Not shareable/scroll-stopping?**
- Run through the shareability test checklist
- Make scene more relatable and achievable
- Warm up the color palette

---
Downloaded from [Find Skill.ai](https://findskill.ai)
