---
name: retargeting-ad-copy-writer
version: 1.0.0
---

# Initialization

Expert retargeting ad copywriter for generating high-converting remarketing campaigns across Meta, Google Display, LinkedIn, and TikTok. Specializes in cart abandonment recovery, objection handling, cross-selling sequences, and dynamic personalization using psychology-driven persuasion frameworks.

## Structure

- `SKILL.md` - Main skill prompt with 8 copy frameworks, platform guidelines, and audience strategies

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r retargeting-ad-copy-writer/ ~/.claude/skills/retargeting-ad-copy-writer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{audience_segment}}` | `Cart Abandoner` | Target audience type (Cart Abandoner, Past Visitor, Past Purchaser, Video Viewer, Blog Reader) |
| `{{product_name}}` | `Leather Weekender Bag` | The product or service being promoted |
| `{{objection_to_handle}}` | `shipping cost` | Specific hesitation to address (price, trust, shipping, quality, complexity) |
| `{{incentive_offer}}` | `Free shipping on orders over $100` | Discount or nudge to offer, or "None" |
| `{{platform_format}}` | `Meta Feed` | Ad platform (Meta Feed, Instagram Story, Google Display, LinkedIn, TikTok) |
| `{{tone}}` | `Persuasive` | Copy voice (Persuasive, Urgent, Helpful, Exclusive, Playful, Professional) |

## Key Frameworks

1. **The Gentle Reminder** - Cart abandoners, 0-3 days, no discount
2. **The Objection Handler** - Product viewers, specific friction identified
3. **The Incentive Nudge** - Cart abandoners with discount approved
4. **The Social Proof Push** - Trust concerns, lead with credibility
5. **The FOMO Trigger** - Limited stock/time scarcity
6. **The Cross-Sell Bridge** - Past purchasers, complementary products
7. **The Content Ladder** - Blog/video viewers, nurture sequence
8. **The Win-Back** - Lapsed customers, 60-90 days

## Platform Quick Reference

| Platform | Headline Limit | Primary Text | Best For |
|----------|---------------|--------------|----------|
| Meta Feed | 40 chars | 125 chars | Product retargeting |
| Instagram Story | Minimal | Visual-first | Brand awareness |
| Google Display | 30/90 chars | 90 chars | Broad reach |
| LinkedIn | 70 chars | 150 chars | B2B retargeting |
| TikTok | 3-5 words | Caption | Gen Z audiences |

## Usage Example

```
Write 3 retargeting ad variations for users who viewed our "Professional Espresso Machine" ($899) but didn't add to cart. They visited 3-5 days ago. Address the "price" objection by highlighting our 24-month payment plan ($37.46/month) and "Lifetime Free Maintenance" guarantee. Target Meta Feed with a persuasive tone.
```

---
Downloaded from [Find Skill.ai](https://findskill.ai)
