---
name: product-photography-generator
description: Create studio-quality product photography prompts for AI image generators. Use this skill when generating product images for e-commerce, Amazon, Etsy, or marketing campaigns. This skill requires initialization before first use - run INIT.md instructions.
platforms:
  - claude
  - chatgpt
  - gemini
  - copilot
difficulty: intermediate
variables:
  - name: "product_type"
    default: "skincare bottle"
    description: "The type of product being photographed"
  - name: "photography_style"
    default: "studio"
    description: "Visual style (studio, lifestyle, flat lay, hero, macro)"
  - name: "background"
    default: "clean white seamless"
    description: "Background setting or color"
  - name: "lighting"
    default: "soft diffused studio lighting"
    description: "Lighting setup (soft, dramatic, natural, etc.)"
  - name: "platform"
    default: "Amazon"
    description: "Target platform (Amazon, Etsy, Shopify, Instagram)"
  - name: "aspect_ratio"
    default: "1:1 square"
    description: "Image dimensions ratio"
---

# Product Photography Generator

Create professional product images using AI that rival expensive photography studios. Generate prompts optimized for Midjourney, DALL-E, and other AI image generators.

## Quick Start

```
I need product photography for: [describe your product]
Platform: [Amazon/Etsy/Shopify/Instagram]
Style preference: [studio/lifestyle/flat lay]
```

## Core Prompt Formulas

### 1. Studio Product Shot (E-commerce Main Images)
```
[product description] on [background color] seamless background, high-key studio lighting, product photography, 85mm lens, sharp focus, professional commercial photography, [aspect ratio]
```

**Example:**
```
matte black perfume bottle with gold cap on pure white seamless background, high-key studio lighting, product photography, 85mm lens, sharp focus, professional commercial photography, 1:1 square
```

### 2. Lifestyle Shot (Context & Usage)
```
[product description] in [setting], [lighting type], lifestyle product photography, [mood/atmosphere], shallow depth of field, [brand aesthetic]
```

**Example:**
```
organic skincare bottles on marble bathroom counter, soft natural morning light through window, lifestyle product photography, spa-like serene atmosphere, shallow depth of field, minimalist luxury aesthetic
```

### 3. Flat Lay Shot (Collections & Bundles)
```
flat lay photography of [products], [arrangement style], on [surface/background], [lighting], overhead shot, styled product photography
```

**Example:**
```
flat lay photography of complete skincare routine with dried botanicals, knolling arrangement, on beige linen fabric, soft diffused daylight, overhead shot, styled product photography
```

### 4. Hero Shot (Marketing & Advertising)
```
[product description], hero shot product photography, [dramatic lighting], [background effect], [dynamic element], advertising campaign style, premium commercial photography
```

**Example:**
```
luxury watch with water splash droplets, hero shot product photography, dramatic rim lighting with blue gel, dark gradient background, water explosion effect, advertising campaign style
```

### 5. Detail/Macro Shot (Quality & Craftsmanship)
```
macro shot of [specific detail] on [product], extreme close-up, [lighting to reveal texture], shallow depth of field, detail photography, [quality descriptors]
```

**Example:**
```
macro shot of hand-stitched leather texture on handbag strap, extreme close-up, side lighting revealing grain, shallow depth of field, detail photography, premium Italian leather
```

## Lighting Quick Reference

| Style | Keywords | Best For |
|-------|----------|----------|
| High-key | "high-key lighting, bright, even illumination" | E-commerce, clean products |
| Low-key | "low-key lighting, dramatic shadows, rim light" | Luxury, premium products |
| Natural | "soft natural daylight, window light" | Lifestyle, organic products |
| Soft | "soft diffused studio lighting, softbox" | Most products |
| Dramatic | "dramatic lighting, rim lighting, color gels" | Hero shots, marketing |
| Backlit | "backlit, translucent glow" | Transparent/glass products |

## Background Reference

### Solid Colors
- **Pure white** - Amazon main images, clean e-commerce
- **Black** - Luxury, premium products
- **Gray** - Professional, versatile
- **Pastels** - Modern, approachable brands

### Textured Surfaces
- **Marble** - Beauty, jewelry, luxury
- **Wood** - Natural, artisan products
- **Concrete** - Industrial, modern tech
- **Linen/Velvet** - Fashion, soft goods

### Environmental
- **Kitchen counter** - Food products
- **Bathroom vanity** - Beauty, skincare
- **Office desk** - Tech, productivity
- **Nature setting** - Sustainable, outdoor products

## Platform Requirements

### Amazon Main Image
- Pure white background (RGB 255,255,255)
- Product fills 85% of frame
- No text, logos, watermarks
- 1:1 square, minimum 2000x2000px
- Add: `pure white background, product fills frame, no text, Amazon compliant`

### Etsy
- More creative freedom
- Lifestyle shots perform well
- Consistent shop aesthetic
- Add: `artisan handmade aesthetic, Etsy shop style`

### Instagram
- Eye-catching, thumb-stopping
- Square (1:1) or portrait (4:5)
- Can be creative and branded
- Add: `Instagram-worthy, social media aesthetic`

## Product Category Templates

### Beauty & Skincare
```
[bottle/jar description] on marble surface, soft natural lighting, beauty product photography, luxury cosmetics aesthetic, fresh ingredients props, clean minimal composition
```

### Electronics & Tech
```
[device description] on dark gradient background, dramatic rim lighting with subtle glow, tech product photography, sleek modern aesthetic, premium commercial quality
```

### Fashion & Accessories
```
[item description] styled with complementary accessories, fashion product photography, [brand aesthetic], professional lighting, lifestyle context
```

### Jewelry
```
[jewelry piece] on velvet display, sparkle-enhancing dramatic lighting, jewelry product photography, [metal finish], sharp focus on details, luxury aesthetic
```

### Food & Beverage
```
[product] with fresh ingredients, natural daylight, food photography, appetizing presentation, [steam/condensation effects], rustic wood surface
```

## Midjourney Parameters

Append to prompts for Midjourney:

| Parameter | Purpose | Value |
|-----------|---------|-------|
| `--ar` | Aspect ratio | `1:1`, `4:5`, `16:9` |
| `--s` | Stylization | `20-100` (lower = more literal) |
| `--q` | Quality | `1` or `2` |
| `--no` | Exclude | `--no text watermark logo` |

**Full example:**
```
premium skincare serum on white marble, soft studio lighting, product photography --ar 1:1 --s 50 --q 2 --no text watermark
```

## Quality Boosting Keywords

Add these to enhance results:
- "professional commercial photography"
- "studio quality"
- "award-winning product photography"
- "advertising campaign quality"
- "85mm lens, sharp focus"

## Terms to Avoid

- "photorealistic" - Makes images look CGI
- "3D render" - Unless specifically wanted
- "digital art" - Less photographic result

## Complete Photography Set Workflow

1. **Main Hero Image** - Clean background, primary listing
2. **Angle Variations** - Front, side, back, 45-degree
3. **Detail Shots** - Macro close-ups of features
4. **Lifestyle Images** - Product in context/use
5. **Scale Reference** - Size comparison with hands/objects
6. **Group Shots** - Bundles and collections

---
Downloaded from [Find Skill.ai](https://findskill.ai)
