---
name: product-photography-generator
version: 1.0.0
description: AI product photography prompt generator for e-commerce and marketing
author: FindSkill.ai
license: MIT
---

# Initialization

This skill provides comprehensive prompt templates and techniques for generating professional product photography using AI image generators like Midjourney, DALL-E, Stable Diffusion, and others.

**Time to initialize**: ~1 minute (prompt-only skill)

## Overview

The Product Photography Generator skill helps e-commerce sellers create studio-quality product images without expensive photography equipment. It covers:

- 5 photography styles (studio, lifestyle, flat lay, hero, macro)
- Lighting techniques for different products
- Platform-specific requirements (Amazon, Etsy, Shopify, Instagram)
- Product category templates
- AI tool parameters (Midjourney, DALL-E)

## Directory Structure

```
product-photography-generator/
├── SKILL.md         # Main skill instructions and prompt formulas
└── INIT.md          # This initialization file
```

## Dependencies

None - this is a prompt-only skill.

## Files to Generate

None - copy SKILL.md content directly to use with any AI assistant.

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r product-photography-generator/ ~/.claude/skills/product-photography-generator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat
4. Describe your product to get customized prompts

## Quick Start Example

After initializing, try this prompt with any AI:

```
I need product photography prompts for a matte black ceramic coffee mug with a minimalist design. I'm selling on Amazon and need:
1. Main listing image (white background)
2. Lifestyle shot (morning kitchen scene)
3. Detail shot (texture close-up)

Please generate Midjourney prompts for each.
```

## Compatibility

Tested with:
- Claude (Anthropic)
- ChatGPT (OpenAI)
- Gemini (Google)
- Copilot (Microsoft)

Works with AI image generators:
- Midjourney
- DALL-E / ChatGPT
- Stable Diffusion
- Leonardo AI
- Ideogram
- Adobe Firefly

## Variables Reference

| Variable | Default | Description |
|----------|---------|-------------|
| `{{product_type}}` | `skincare bottle` | Product being photographed |
| `{{photography_style}}` | `studio` | Style (studio/lifestyle/flat lay/hero/macro) |
| `{{background}}` | `clean white seamless` | Background setting |
| `{{lighting}}` | `soft diffused studio` | Lighting setup |
| `{{platform}}` | `Amazon` | Target sales platform |
| `{{aspect_ratio}}` | `1:1 square` | Image dimensions |

## Supported Use Cases

- Amazon FBA product listings
- Etsy shop photography
- Shopify store images
- Instagram product posts
- Marketing campaign visuals
- Product catalog creation
- Social media ads
- Website hero images

---
Downloaded from [Find Skill.ai](https://findskill.ai)
