---
name: petty-problem-escalator
version: 1.0.0
---

# Petty Problem Escalator - Initialization

Transform mundane complaints into hilariously catastrophic existential crises using comedic escalation, the Rule of Three, and absurdist humor techniques.

## Structure

```
petty-problem-escalator/
├── SKILL.md      # Main skill prompt (copy to AI assistant)
└── INIT.md       # This initialization file
```

## Files to Generate

None required. This is a prompt-only skill.

## Post-Init Steps

### Claude Code

```bash
# Copy skill to Claude Code skills directory
cp -r petty-problem-escalator/ ~/.claude/skills/petty-problem-escalator/
```

### Other AI Assistants

1. Open `SKILL.md`
2. Copy all content after the frontmatter (everything after the second `---`)
3. Paste into your AI assistant's system prompt or custom instructions
4. Begin using by sharing a minor complaint

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `escalation_stages` | `5` | Number of escalation phases (3-7 recommended) |
| `comedic_tone` | `absurdist` | Voice: absurdist, sarcastic, investigative, dramatic, pedantic |
| `target_scope` | `cosmic` | Endpoint: personal, professional, systemic, cosmic |
| `max_specificity` | `high` | Detail level: minimal, moderate, high |
| `humor_darkness` | `3` | Scale 1-5; 1=light, 5=nihilistic |
| `output_format` | `paragraph` | Style: paragraph, bullet_points, monologue, scenario |

## Quick Usage Examples

### Basic Usage
```
User: My coffee got cold

AI: [Escalates through 5 stages from "ruined morning" to "proof the universe is hostile"]
```

### With Parameters
```
User: My WiFi is slow. Use investigative tone with 3 stages.

AI: [John Oliver-style investigation revealing systemic ISP conspiracy]
```

### Different Workflows

**Rule of Three (quick):**
```
User: I stubbed my toe. Use rule of three format.
```

**Character Perspectives:**
```
User: My phone died. Give me multiple character perspectives.
```

**Metaphorical Escalation:**
```
User: My socks don't match. Use metaphorical escalation.
```

## Workflows Available

1. **Classic Linear Escalation** - 5-stage build from immediate to cosmic
2. **Rule of Three** - Setup, setup, punchline structure
3. **Investigative Escalation** - John Oliver "and it gets worse" style
4. **Character-Based** - Multiple perspectives (IT, Executive, Sociologist, Alien)
5. **Metaphorical Escalation** - Size-class expansion to cosmic philosophy

## Platform Tips

| Platform | Strength | Best Workflow |
|----------|----------|---------------|
| Claude | Structured escalation | Investigative |
| ChatGPT | Character consistency | Character-based |
| Gemini | Creative metaphors | Metaphorical |
| Copilot | Balanced output | Classic Linear |

## Troubleshooting

| Issue | Solution |
|-------|----------|
| Too random | Add transitional phrases between stages |
| Not funny | Ground in relatable truth first |
| Plateaus | Explicitly move to next scope level |
| Too dark | Reduce humor_darkness to 1-2 |
| Too long | Reduce escalation_stages to 3 |

## Example Output

**Input:** "I forgot my sunscreen at the beach"

**Output:**
> Stage 1: Sunburn. Immediate discomfort. Your skin is now the color of a tomato that made poor life choices.
>
> Stage 2: Skin cancer risk increases. You've essentially Russian-rouletted your epidermis.
>
> Stage 3: Your dating life collapses. Nobody swipes right on someone who looks like a molting lobster.
>
> Stage 4: This is actually why humanity is struggling. We can't even remember basic self-preservation supplies.
>
> Stage 5: Sunscreen is, upon further investigation, a government conspiracy to prevent us from developing our natural photosynthesis abilities. They WANT us weak.

---
Downloaded from [Find Skill.ai](https://findskill.ai)
