---
name: landing-page-headline-fixer
version: 1.0.0
---

# Initialization

Transform generic, feature-focused headlines into compelling, benefit-driven headlines that maximize conversion rates. This skill applies 12 proven psychological triggers backed by a study of 2,847 tested headlines across 47 industries.

## Structure

- `SKILL.md` - Main skill prompt with 12 psychological triggers, 4 workflows, and A/B testing frameworks

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r landing-page-headline-fixer/ ~/.claude/skills/landing-page-headline-fixer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter (starting from "You are an expert...")
3. Paste into AI assistant system prompt or custom instructions

## Quick Start

After installation, use these prompts:

**Basic headline fix:**
```
My headline is "Cloud-Based Project Management Software".
Fix it for better conversions.
```

**With context:**
```
Current headline: "Automated Scheduling Software for Teams"
CTR: 0.9%
Conversion: 1.8%
Audience: CTOs and ops managers
Generate 5 benefit-focused variations with A/B testing recommendations.
```

**Audience-specific:**
```
Adapt this headline for executive, practitioner, and technical buyer personas:
"Save time on project management"
```

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{target_audience}}` | `general_audience` | Persona: executive, practitioner, technical_buyer, end_user |
| `{{primary_trigger}}` | `specificity` | Focus trigger: specificity, pattern_disruption, social_proof, urgency, transformation, risk_reversal |
| `{{include_quantification}}` | `true` | Add metrics/numbers for credibility (40-190% CTR boost) |
| `{{tone_style}}` | `professional` | Voice: professional, conversational, playful, aggressive, empathetic |
| `{{industry_context}}` | `general` | Sector: SaaS, ecommerce, services, health, finance, education |
| `{{transformation_type}}` | `efficiency` | Benefit focus: efficiency, financial, emotional, status, freedom, security |

## The 12 Psychological Triggers (Quick Reference)

| # | Trigger | CTR Impact | Best For |
|---|---------|------------|----------|
| 1 | Pattern Disruption | 3%+ vs 0.4% | Fashion, B2C, crowded markets |
| 2 | Specificity Layering | +40-190% | All industries |
| 3 | Owned Negative | +2.5-3.2% | Premium products, services |
| 4 | Time-Bound Results | +60-120% | SaaS, courses, B2B |
| 5 | Reverse-Risk | +100-160% | Services, high-ticket |
| 6 | Social Proof | +30-80% | SaaS, tools, B2B |
| 7 | Curiosity Gap | +50-100% | Content, lead magnets |
| 8 | Status Inversion | +40-90% | Premium, professional |
| 9 | Transformation Focus | +80-150% | SaaS, coaching, courses |
| 10 | Quantified Constraint | +45-85% | Services, consulting |
| 11 | Educational Value | +35-70% | B2B SaaS, thought leadership |
| 12 | Inverted Benefit | +55-95% | Productivity, health |

## Industry-Specific Combinations

| Industry | Best Triggers |
|----------|---------------|
| B2B SaaS | Specificity + Time-Bound + Reverse-Risk |
| E-commerce Fashion | Pattern Disruption + Owned Negative + Status Inversion |
| Professional Services | Specificity + Quantified Constraint + Time-Bound |
| Health/Fitness | Inverted Benefit + Owned Negative + Transformation |
| Finance | Specificity + Transparency + Time-Bound Proof |

## Expected Output Format

The skill will generate:
1. Trigger audit of your current headline
2. 4-6 optimized variations with predicted performance
3. A/B testing roadmap (which to test first, success metrics)
4. Supporting recommendations (subheadline, CTA alignment)

---
Downloaded from [Find Skill.ai](https://findskill.ai)
