---
name: frontend-design-pro
version: 2.0.0
---

# Initialization

Create distinctive, accessible frontend interfaces with design systems, WCAG compliance, and production-grade component libraries that avoid generic AI aesthetics.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive instructions for design systems, accessibility, and component development

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r frontend-design-pro/ ~/.claude/skills/frontend-design-pro/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{target_accessibility_level}}` | `WCAG_AA` | WCAG compliance target (A, AA, AAA) |
| `{{design_framework}}` | `figma` | Design tool being used |
| `{{component_library_framework}}` | `react` | Frontend framework for components |
| `{{token_organization_depth}}` | `3_tier` | Design token hierarchy depth |
| `{{documentation_platform}}` | `storybook` | Component documentation tool |
| `{{theming_approach}}` | `css_variables_with_prefers_color_scheme` | Theme implementation method |

## Capabilities

This skill helps you with:

1. **Design Token Systems** - Create 3-tier token architecture (primitive, semantic, component)
2. **Accessible Components** - Build WCAG 2.1 compliant components with semantic HTML
3. **React/TypeScript Components** - Production-grade polymorphic components with full types
4. **Storybook Documentation** - Comprehensive stories with accessibility testing
5. **Design-to-Code Handoff** - Structure Figma specs for developers
6. **Dark Mode Implementation** - CSS variables with system preference detection

## Related Skills

- Design System Architect - `/skills/ux-design/design-system-architect/`
- Figma Design Tokens Exporter - `/skills/design-media/figma-design-tokens/`
- Accessible Color Palette Generator - `/skills/design-media/accessible-color-palette-generator/`

---
Downloaded from [Find Skill.ai](https://findskill.ai)
