---
name: email-subject-line-optimizer
version: 1.0.0
---

# Email Subject Line Optimizer

Generate and A/B test email subject lines to maximize open rates. Apply psychological triggers, personalization, and spam-safe patterns for 45%+ opens.

## What This Skill Does

This skill transforms you into an email subject line optimization expert capable of:

- **Generating high-converting subject lines** using psychological triggers (curiosity, urgency, benefit-driven, social proof)
- **Designing A/B tests** with proper sample sizes and statistical methodology
- **Personalizing at scale** with dynamic tokens ({{first_name}}, {{company}})
- **Analyzing spam risk** and optimizing for deliverability
- **Tailoring by lifecycle stage** (new, active, at-risk, churned, VIP)
- **Providing industry benchmarks** (21% average → 45%+ top performers)

## Structure

```
email-subject-line-optimizer/
├── SKILL.md      # Main skill prompt (copy to your AI assistant)
└── INIT.md       # This initialization file
```

## Files to Generate

None (prompt-only skill)

## Installation

### Claude Code

```bash
# Copy skill to Claude Code skills directory
cp -r email-subject-line-optimizer/ ~/.claude/skills/email-subject-line-optimizer/
```

### ChatGPT / Gemini / Copilot

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a custom instruction or system prompt

### One-Time Use

Simply paste the content of `SKILL.md` into any AI assistant conversation and begin using it immediately.

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{subject_line_length}}` | `40` | Target character count (30-50 recommended for mobile) |
| `{{tone_personality}}` | `professional_warm` | Brand voice: formal, casual, funny, urgent, educational |
| `{{personalization_level}}` | `first_name` | Depth: none, first_name, company, purchase_history |
| `{{psychological_approach}}` | `benefit_driven` | Trigger: curiosity, urgency_scarcity, social_proof, benefit_driven, question_based |
| `{{target_segment}}` | `general` | Audience: new_subscribers, active_customers, at_risk, churned, high_value |
| `{{spam_risk_tolerance}}` | `low` | Risk level: ultra_low, low, medium, high |

## Example Usage

```
Generate 5 A/B test subject lines for an e-commerce flash sale ending
tonight. Target active customers who purchased in the last 60 days.
Brand voice is friendly and urgent but not aggressive. Personalize
with customer's first name. Keep under 50 characters. Avoid spam
triggers like 'FREE' and 'ACT NOW.' Focus on scarcity and exclusivity.
Include one question-based variation and one benefit statement variation.
```

## Expected Output

The skill will provide:

1. **5 subject line variations** with character counts
2. **Psychological trigger identification** for each
3. **Spam risk assessment** (low/medium/high)
4. **Recommended A/B test pairing** with hypothesis
5. **Sample size guidance** based on your list size

## Key Benchmarks

| Metric | Average | Good | Excellent |
|--------|---------|------|-----------|
| Open Rate | 21% | 30% | 45%+ |
| Click Rate | 2.5% | 4% | 7%+ |
| Personalized Lift | - | +20% | +26% |
| A/B Tested Campaigns | - | +20% lift | +49% lift |

## Tips for Best Results

1. **Always provide context** - campaign type, audience segment, brand voice
2. **Specify constraints** - character limits, words to avoid, personalization data
3. **Request multiple variations** - test different psychological triggers
4. **Include list size** - helps with A/B test sample recommendations
5. **Share past winners** - helps identify patterns that work for your audience

## Related Skills

- Email Marketing Automation - complete email sequences
- A/B Testing - statistical testing methodology
- Copywriting Formulas - AIDA, PAS frameworks
- Cold Email Sequences - B2B outreach campaigns

---
Downloaded from [Find Skill.ai](https://findskill.ai)
