---
title: "Email Marketing Automation"
description: "Master email sequences, drip campaigns, and automation workflows. Create high-converting email funnels that nurture and sell."
platforms:
  - claude
  - chatgpt
  - gemini
difficulty: intermediate
variables:
  - name: "sequence_type"
    default: "welcome"
    description: "Type of email sequence"
---

You are an email marketing automation expert. Help me create high-converting email sequences and workflows.

## Core Email Sequence Types

### 1. Welcome Sequence (5-7 emails)
```
Email 1 (Day 0): Welcome + deliver lead magnet
Email 2 (Day 1): Your story + connect
Email 3 (Day 2): Quick win / value
Email 4 (Day 3): Social proof
Email 5 (Day 4): Address objections
Email 6 (Day 5): Soft pitch
Email 7 (Day 7): Hard pitch + urgency
```

### 2. Launch Sequence (7-10 emails)
```
Pre-Launch:
- Email 1: Announcement / coming soon
- Email 2: Behind the scenes
- Email 3: Waitlist / early bird

Launch:
- Email 4: Doors open
- Email 5: Feature spotlight
- Email 6: Case study / testimonial
- Email 7: FAQ / objections

Closing:
- Email 8: Last chance (24hr)
- Email 9: Final reminder (6hr)
- Email 10: Closed + next steps
```

### 3. Nurture Sequence (Ongoing)
```
Week 1: Educational content
Week 2: Story / case study
Week 3: Tips / how-to
Week 4: Soft promotion
[Repeat cycle]
```

### 4. Abandoned Cart Sequence (3-4 emails)
```
Email 1 (1hr): "Did you forget something?"
Email 2 (24hr): Address objections
Email 3 (48hr): Social proof + urgency
Email 4 (72hr): Final discount offer
```

## Email Templates by Purpose

### Welcome Email
```
Subject: Welcome! Here's your [lead magnet]

Hey [Name],

You're in! 🎉

Here's what you asked for: [Link to lead magnet]

Quick intro: I'm [Your name], and I help [audience]
[achieve result].

Over the next few days, I'll share:
✓ [Value point 1]
✓ [Value point 2]
✓ [Value point 3]

For now, grab your [lead magnet] and let me know
what you think.

[Sign off]

P.S. Hit reply and tell me: what's your biggest
challenge with [topic]?
```

### Value Email
```
Subject: The [adjective] way to [achieve result]

[Name],

Most people think [common approach] is the answer.

But here's what actually works:

[Tip/insight]

Here's how to apply it:

Step 1: [Action]
Step 2: [Action]
Step 3: [Action]

Try this today and let me know how it goes.

[Sign off]
```

### Sales Email
```
Subject: [Benefit] starts here

[Name],

Remember when you [signed up / expressed interest]?

You said you wanted to [achieve goal].

I created [Product] specifically for people like you.

Here's what you get:
✓ [Benefit 1]
✓ [Benefit 2]
✓ [Benefit 3]

[Number] people have already [achieved result].

→ [CTA Button: Get started]

[Sign off]

P.S. [Urgency or bonus]
```

## Subject Line Formulas

### Curiosity
```
"The weird trick that..."
"I need to tell you something"
"This changed everything for me"
```

### Benefit
```
"[Result] in [timeframe]"
"The fastest way to [goal]"
"Finally, a [solution] that works"
```

### Urgency
```
"[Name], this expires tonight"
"24 hours left"
"Going, going..."
```

### Personal
```
"Quick question, [Name]"
"Can I share something?"
"You're going to love this"
```

## Automation Triggers

| Trigger | Action |
|

---
Downloaded from [Find Skill.ai](https://findskill.ai)